/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parser.result.SQLParsedResult;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AggregationColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.GroupByColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Table;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.MySQLEvalVisitor;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class ParseContext {
    private static final String AUTO_GEN_TOKE_KEY_TEMPLATE = "sharding_auto_gen_%d";
    private static final String SHARDING_GEN_ALIAS = "sharding_gen_%s";
    private final String autoGenTokenKey;
    private final SQLParsedResult parsedResult = new SQLParsedResult();
    private final int parseContextIndex;
    private Collection<String> shardingColumns;
    private boolean hasOrCondition;
    private final ConditionContext currentConditionContext = new ConditionContext();
    private Table currentTable;
    private int selectItemsCount;
    private final Collection<String> selectItems = new HashSet<String>();
    private boolean hasAllColumn;
    private ParseContext parentParseContext;
    private List<ParseContext> subParseContext = new LinkedList<ParseContext>();
    private int itemIndex;

    public ParseContext(int parseContextIndex) {
        this.parseContextIndex = parseContextIndex;
        this.autoGenTokenKey = String.format(AUTO_GEN_TOKE_KEY_TEMPLATE, parseContextIndex);
    }

    public void increaseItemIndex() {
        ++this.itemIndex;
    }

    public void setCurrentTable(String currentTableName, Optional<String> currentAlias) {
        Table table = new Table(SQLUtil.getExactlyValue(currentTableName), currentAlias.isPresent() ? Optional.of((Object)SQLUtil.getExactlyValue((String)currentAlias.get())) : currentAlias);
        this.parsedResult.getRouteContext().getTables().add(table);
        this.currentTable = table;
    }

    public Table addTable(SQLExprTableSource x) {
        Table result = new Table(SQLUtil.getExactlyValue(x.getExpr().toString()), SQLUtil.getExactlyValue(x.getAlias()));
        this.parsedResult.getRouteContext().getTables().add(result);
        return result;
    }

    public void addCondition(SQLExpr expr, Condition.BinaryOperator operator, List<SQLExpr> valueExprList, DatabaseType databaseType, List<Object> parameters) {
        Optional<Condition.Column> column = this.getColumn(expr);
        if (!column.isPresent() || !this.shardingColumns.contains(((Condition.Column)column.get()).getColumnName())) {
            return;
        }
        ArrayList<ValuePair> values = new ArrayList<ValuePair>(valueExprList.size());
        for (SQLExpr each : valueExprList) {
            ValuePair evalValue = this.evalExpression(databaseType, (SQLObject)each, parameters);
            if (null == evalValue) continue;
            values.add(evalValue);
        }
        if (values.isEmpty()) {
            return;
        }
        this.addCondition((Condition.Column)column.get(), operator, values);
    }

    public void addCondition(String columnName, String tableName, Condition.BinaryOperator operator, SQLExpr valueExpr, DatabaseType databaseType, List<Object> parameters) {
        Condition.Column column = this.createColumn(columnName, tableName);
        if (!this.shardingColumns.contains(column.getColumnName())) {
            return;
        }
        ValuePair value = this.evalExpression(databaseType, (SQLObject)valueExpr, parameters);
        if (null != value) {
            this.addCondition(column, operator, Collections.singletonList(value));
        }
    }

    private void addCondition(Condition.Column column, Condition.BinaryOperator operator, List<ValuePair> valuePairs) {
        Condition condition;
        Optional<Condition> optionalCondition = this.currentConditionContext.find(column.getTableName(), column.getColumnName(), operator);
        if (optionalCondition.isPresent()) {
            condition = (Condition)optionalCondition.get();
        } else {
            condition = new Condition(column, operator);
            this.currentConditionContext.add(condition);
        }
        for (ValuePair each : valuePairs) {
            condition.getValues().add(each.value);
            if (each.paramIndex <= -1) continue;
            condition.getValueIndices().add(each.paramIndex);
        }
    }

    private ValuePair evalExpression(DatabaseType databaseType, SQLObject sqlObject, List<Object> parameters) {
        MySQLEvalVisitor visitor;
        if (sqlObject instanceof SQLMethodInvokeExpr) {
            return null;
        }
        switch (databaseType.name().toLowerCase()) {
            case "mysql": 
            case "h2": {
                visitor = new MySQLEvalVisitor();
                break;
            }
            default: {
                visitor = SQLEvalVisitorUtils.createEvalVisitor((String)databaseType.name());
            }
        }
        visitor.setParameters(parameters);
        sqlObject.accept((SQLASTVisitor)visitor);
        Object value = SQLEvalVisitorUtils.getValue((SQLObject)sqlObject);
        if (null == value) {
            return null;
        }
        Object finalValue = value instanceof Comparable ? (Comparable)value : "";
        Integer index = (Integer)sqlObject.getAttribute("EVAL_VAR_INDEX");
        if (null == index) {
            index = -1;
        }
        return new ValuePair((Comparable<?>)finalValue, index);
    }

    private Optional<Condition.Column> getColumn(SQLExpr expr) {
        if (expr instanceof SQLPropertyExpr) {
            return Optional.fromNullable((Object)this.getColumnWithQualifiedName((SQLPropertyExpr)expr));
        }
        if (expr instanceof SQLIdentifierExpr) {
            return Optional.fromNullable((Object)this.getColumnWithoutAlias((SQLIdentifierExpr)expr));
        }
        return Optional.absent();
    }

    private Condition.Column getColumnWithQualifiedName(SQLPropertyExpr expr) {
        Optional<Table> table = this.findTable(((SQLIdentifierExpr)expr.getOwner()).getName());
        return expr.getOwner() instanceof SQLIdentifierExpr && table.isPresent() ? this.createColumn(expr.getName(), ((Table)table.get()).getName()) : null;
    }

    private Condition.Column getColumnWithoutAlias(SQLIdentifierExpr expr) {
        return null != this.currentTable ? this.createColumn(expr.getName(), this.currentTable.getName()) : null;
    }

    private Condition.Column createColumn(String columnName, String tableName) {
        return new Condition.Column(SQLUtil.getExactlyValue(columnName), SQLUtil.getExactlyValue(tableName));
    }

    private Optional<Table> findTable(String tableNameOrAlias) {
        Optional<Table> tableFromName = this.findTableFromName(tableNameOrAlias);
        return tableFromName.isPresent() ? tableFromName : this.findTableFromAlias(tableNameOrAlias);
    }

    public boolean isBinaryOperateWithAlias(SQLPropertyExpr x, String tableOrAliasName) {
        return x.getParent() instanceof SQLBinaryOpExpr && this.findTableFromAlias(SQLUtil.getExactlyValue(tableOrAliasName)).isPresent();
    }

    private Optional<Table> findTableFromName(String name) {
        for (Table each : this.parsedResult.getRouteContext().getTables()) {
            if (!each.getName().equalsIgnoreCase(SQLUtil.getExactlyValue(name))) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private Optional<Table> findTableFromAlias(String alias) {
        for (Table each : this.parsedResult.getRouteContext().getTables()) {
            if (!each.getAlias().isPresent() || !((String)each.getAlias().get()).equalsIgnoreCase(SQLUtil.getExactlyValue(alias))) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public void addDerivedColumnsForAvgColumn(AggregationColumn avgColumn) {
        this.addDerivedColumnForAvgColumn(avgColumn, this.getDerivedCountColumn(avgColumn));
        this.addDerivedColumnForAvgColumn(avgColumn, this.getDerivedSumColumn(avgColumn));
    }

    private void addDerivedColumnForAvgColumn(AggregationColumn avgColumn, AggregationColumn derivedColumn) {
        avgColumn.getDerivedColumns().add(derivedColumn);
        this.parsedResult.getMergeContext().getAggregationColumns().add(derivedColumn);
    }

    private AggregationColumn getDerivedCountColumn(AggregationColumn avgColumn) {
        String expression = avgColumn.getExpression().replaceFirst(AggregationColumn.AggregationType.AVG.toString(), AggregationColumn.AggregationType.COUNT.toString());
        return new AggregationColumn(expression, AggregationColumn.AggregationType.COUNT, (Optional<String>)Optional.of((Object)this.generateDerivedColumnAlias()), avgColumn.getOption());
    }

    private String generateDerivedColumnAlias() {
        return String.format(SHARDING_GEN_ALIAS, ++this.selectItemsCount);
    }

    private AggregationColumn getDerivedSumColumn(AggregationColumn avgColumn) {
        String expression = avgColumn.getExpression().replaceFirst(AggregationColumn.AggregationType.AVG.toString(), AggregationColumn.AggregationType.SUM.toString());
        if (avgColumn.getOption().isPresent()) {
            expression = expression.replaceFirst((String)avgColumn.getOption().get() + " ", "");
        }
        return new AggregationColumn(expression, AggregationColumn.AggregationType.SUM, (Optional<String>)Optional.of((Object)this.generateDerivedColumnAlias()), (Optional<String>)Optional.absent());
    }

    public void addOrderByColumn(int index, OrderByColumn.OrderByType orderByType) {
        this.parsedResult.getMergeContext().getOrderByColumns().add(new OrderByColumn(index, orderByType));
    }

    public void addOrderByColumn(Optional<String> owner, String name, OrderByColumn.OrderByType orderByType) {
        String rawName = SQLUtil.getExactlyValue(name);
        this.parsedResult.getMergeContext().getOrderByColumns().add(new OrderByColumn(owner, rawName, this.getAlias(rawName), orderByType));
    }

    private Optional<String> getAlias(String name) {
        if (this.containsSelectItem(name)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.generateDerivedColumnAlias());
    }

    private boolean containsSelectItem(String selectItem) {
        return this.hasAllColumn || this.selectItems.contains(selectItem);
    }

    public void addGroupByColumns(Optional<String> owner, String name, OrderByColumn.OrderByType orderByType) {
        String rawName = SQLUtil.getExactlyValue(name);
        this.parsedResult.getMergeContext().getGroupByColumns().add(new GroupByColumn(owner, rawName, this.getAlias(rawName), orderByType));
    }

    public void mergeCurrentConditionContext() {
        if (!this.parsedResult.getRouteContext().getTables().isEmpty()) {
            if (this.parsedResult.getConditionContexts().isEmpty()) {
                this.parsedResult.getConditionContexts().add(this.currentConditionContext);
            }
            return;
        }
        Optional<SQLParsedResult> target = this.findValidParseResult();
        if (!target.isPresent()) {
            if (this.parsedResult.getConditionContexts().isEmpty()) {
                this.parsedResult.getConditionContexts().add(this.currentConditionContext);
            }
            return;
        }
        this.parsedResult.getRouteContext().getTables().addAll(((SQLParsedResult)target.get()).getRouteContext().getTables());
        this.parsedResult.getConditionContexts().addAll(((SQLParsedResult)target.get()).getConditionContexts());
    }

    private Optional<SQLParsedResult> findValidParseResult() {
        for (ParseContext each : this.subParseContext) {
            each.mergeCurrentConditionContext();
            if (each.getParsedResult().getRouteContext().getTables().isEmpty()) continue;
            return Optional.of((Object)each.getParsedResult());
        }
        return Optional.absent();
    }

    public void registerSelectItem(String selectItem) {
        String rawItemExpr = SQLUtil.getExactlyValue(selectItem);
        if ("*".equals(rawItemExpr)) {
            this.hasAllColumn = true;
            return;
        }
        this.selectItems.add(rawItemExpr);
    }

    public String getAutoGenTokenKey() {
        return this.autoGenTokenKey;
    }

    public SQLParsedResult getParsedResult() {
        return this.parsedResult;
    }

    public int getParseContextIndex() {
        return this.parseContextIndex;
    }

    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }

    public boolean isHasOrCondition() {
        return this.hasOrCondition;
    }

    public ConditionContext getCurrentConditionContext() {
        return this.currentConditionContext;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public int getSelectItemsCount() {
        return this.selectItemsCount;
    }

    public Collection<String> getSelectItems() {
        return this.selectItems;
    }

    public boolean isHasAllColumn() {
        return this.hasAllColumn;
    }

    public ParseContext getParentParseContext() {
        return this.parentParseContext;
    }

    public List<ParseContext> getSubParseContext() {
        return this.subParseContext;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public void setShardingColumns(Collection<String> shardingColumns) {
        this.shardingColumns = shardingColumns;
    }

    public void setHasOrCondition(boolean hasOrCondition) {
        this.hasOrCondition = hasOrCondition;
    }

    public void setParentParseContext(ParseContext parentParseContext) {
        this.parentParseContext = parentParseContext;
    }

    private static class ValuePair {
        private final Comparable<?> value;
        private final Integer paramIndex;

        @ConstructorProperties(value={"value", "paramIndex"})
        public ValuePair(Comparable<?> value, Integer paramIndex) {
            this.value = value;
            this.paramIndex = paramIndex;
        }
    }
}

