/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.QueryRowField;
import com.databend.client.data.ColumnTypeHandler;
import com.databend.client.data.ColumnTypeHandlerFactory;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ParseJsonDataUtils {
    private ParseJsonDataUtils() {
    }

    public static Iterable<List<Object>> parseRawData(List<QueryRowField> schema, List<List<Object>> data) {
        if (data == null || schema == null) {
            return null;
        }
        ColumnTypeHandler[] typeHandlers = ParseJsonDataUtils.createTypeHandlers(schema);
        ImmutableList.Builder rows = ImmutableList.builderWithExpectedSize(data.size());
        for (List<Object> row : data) {
            if (row.size() != typeHandlers.length) {
                throw new IllegalArgumentException("row / column does not match schema");
            }
            ArrayList<Object> newRow = new ArrayList<Object>(typeHandlers.length);
            int column = 0;
            for (Object value : row) {
                if (value != null) {
                    value = typeHandlers[column].parseValue(value);
                }
                newRow.add(value);
                ++column;
            }
            rows.add(Collections.unmodifiableList(newRow));
        }
        return rows.build();
    }

    private static ColumnTypeHandler[] createTypeHandlers(List<QueryRowField> schema) {
        int index = 0;
        ColumnTypeHandler[] typeHandlers = new ColumnTypeHandler[schema.size()];
        for (QueryRowField field : schema) {
            typeHandlers[index++] = ColumnTypeHandlerFactory.getTypeHandler(field.getDataType());
        }
        return typeHandlers;
    }
}

