/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DatabendSession;
import com.databend.client.ParseJsonDataUtils;
import com.databend.client.QueryAffect;
import com.databend.client.QueryRowField;
import com.databend.client.QueryStats;
import com.databend.client.errors.QueryErrors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.List;

public class QueryResults {
    private final String id;
    private final String sessionId;
    private final DatabendSession session;
    private final List<QueryRowField> schema;
    private final Iterable<List<Object>> data;
    private final String state;
    private final QueryErrors error;
    private final QueryStats stats;
    private final QueryAffect affect;
    private final URI statsUri;
    private final URI finalUri;
    private final URI nextUri;
    private final URI killUri;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="session_id") String sessionId, @JsonProperty(value="session") DatabendSession session, @JsonProperty(value="schema") List<QueryRowField> schema, @JsonProperty(value="data") List<List<Object>> data, @JsonProperty(value="state") String state, @JsonProperty(value="error") QueryErrors error, @JsonProperty(value="stats") QueryStats stats, @JsonProperty(value="affect") QueryAffect affect, @JsonProperty(value="stats_uri") URI statsUri, @JsonProperty(value="final_uri") URI finalUri, @JsonProperty(value="next_uri") URI nextUri, @JsonProperty(value="kill_uri") URI killUri) {
        this.id = id;
        this.sessionId = sessionId;
        this.session = session;
        this.schema = schema;
        this.data = ParseJsonDataUtils.parseRawData(schema, data);
        this.state = state;
        this.error = error;
        this.stats = stats;
        this.affect = affect;
        this.statsUri = statsUri;
        this.finalUri = finalUri;
        this.nextUri = nextUri;
        this.killUri = killUri;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty
    public DatabendSession getSession() {
        return this.session;
    }

    @JsonProperty
    public List<QueryRowField> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Iterable<List<Object>> getData() {
        return this.data;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public QueryErrors getError() {
        return this.error;
    }

    @JsonProperty
    public QueryStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public QueryAffect getAffect() {
        return this.affect;
    }

    @JsonProperty
    public URI getStatsUri() {
        return this.statsUri;
    }

    @JsonProperty
    public URI getFinalUri() {
        return this.finalUri;
    }

    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @JsonProperty
    public URI getKillUri() {
        return this.killUri;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("sessionId", this.sessionId).add("session", this.session).add("schema", this.schema).add("data", this.data).add("state", this.state).add("error", this.error).add("stats", this.stats).add("affect", this.affect).add("statsUri", this.statsUri).add("finalUri", this.finalUri).add("nextUri", this.nextUri).add("killUri", this.killUri).toString();
    }
}

