/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabendRawType {
    private final String type;
    private final boolean isNullable;

    @JsonCreator
    public DatabendRawType(String type) {
        Pattern pattern = Pattern.compile("Nullable\\((.+)\\)", 2);
        if (pattern.matcher(type).matches()) {
            this.isNullable = true;
            Matcher matcher = pattern.matcher(type);
            matcher.find();
            this.type = matcher.group(1);
        } else {
            this.isNullable = false;
            this.type = type;
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("isNullable", this.isNullable).toString();
    }
}

