/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class Float64Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public Float64Handler() {
        this.isNullable = false;
    }

    public Float64Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Double parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    private double parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("Float64 type is not nullable");
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

