/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.errors;

import com.databend.client.errors.CloudErrorKinds;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;

public class CloudErrors {
    private final String kind;
    private final String message;

    @JsonCreator
    public CloudErrors(@JsonProperty(value="kind") String kind, @JsonProperty(value="message") String message) {
        this.kind = kind;
        this.message = message;
    }

    public static CloudErrors tryParse(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(json, CloudErrors.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @JsonProperty
    public String getKind() {
        return this.kind;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("kind", this.kind).add("message", this.message).toString();
    }

    public CloudErrorKinds tryGetErrorKind() {
        return CloudErrorKinds.tryGetErrorKind(this.kind);
    }
}

