/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.DatabendClient;
import com.databend.client.QueryResults;
import com.databend.client.QueryRowField;
import com.databend.jdbc.AbstractDatabendResultSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;

public class DatabendResultSet
extends AbstractDatabendResultSet {
    private final String queryId;
    private final Statement statement;
    private final DatabendClient client;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private boolean closeStatementOnClose;

    private DatabendResultSet(Statement statement, DatabendClient client, List<QueryRowField> schema, long maxRows) throws SQLException {
        super(Optional.of(Objects.requireNonNull(statement, "statement is null")), schema, new AsyncIterator<List<Object>>(DatabendResultSet.flatten(new ResultsPageIterator(client), maxRows), client));
        this.statement = statement;
        this.client = client;
        this.queryId = client.getResults().getId();
    }

    static DatabendResultSet create(Statement statement, DatabendClient client, long maxRows) throws SQLException {
        Objects.requireNonNull(client, "client is null");
        List<QueryRowField> s = client.getResults().getSchema();
        return new DatabendResultSet(statement, client, s, maxRows);
    }

    private static <T> Iterator<T> flatten(Iterator<Iterable<T>> iterator2, long maxRows) {
        Stream stream = Streams.stream(iterator2).flatMap(Streams::stream);
        if (maxRows > 0L) {
            stream = stream.limit(maxRows);
        }
        return stream.iterator();
    }

    public String getQueryId() {
        return this.queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCloseStatementOnClose() throws SQLException {
        boolean alreadyClosed;
        DatabendResultSet databendResultSet = this;
        synchronized (databendResultSet) {
            alreadyClosed = this.closed;
            if (!alreadyClosed) {
                this.closeStatementOnClose = true;
            }
        }
        if (alreadyClosed) {
            this.statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean closeStatement;
        DatabendResultSet databendResultSet = this;
        synchronized (databendResultSet) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            closeStatement = this.closeStatementOnClose;
        }
        ((AsyncIterator)this.results).cancel();
        this.client.close();
        if (closeStatement) {
            this.statement.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    static class AsyncIterator<T>
    extends AbstractIterator<T> {
        private static final int MAX_QUEUED_ROWS = 50000;
        private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Trino JDBC worker-%s").setDaemon(true).build());
        private final DatabendClient client;
        private final BlockingQueue<T> rowQueue;
        private final Semaphore semaphore = new Semaphore(0);
        private final Future<?> future;
        private volatile boolean cancelled;
        private volatile boolean finished;

        public AsyncIterator(Iterator<T> dataIterator, DatabendClient client) {
            this(dataIterator, client, Optional.empty());
        }

        @VisibleForTesting
        AsyncIterator(Iterator<T> dataIterator, DatabendClient client, Optional<BlockingQueue<T>> queue) {
            Objects.requireNonNull(dataIterator, "dataIterator is null");
            this.client = client;
            this.rowQueue = queue.orElseGet(() -> new ArrayBlockingQueue(50000));
            this.cancelled = false;
            this.finished = false;
            this.future = executorService.submit(() -> {
                try {
                    while (dataIterator.hasNext()) {
                        this.rowQueue.put(dataIterator.next());
                        this.semaphore.release();
                    }
                }
                catch (InterruptedException e) {
                    client.close();
                    this.rowQueue.clear();
                    throw new RuntimeException(new SQLException("ResultSet thread was interrupted", e));
                }
                finally {
                    this.semaphore.release();
                    this.finished = true;
                }
            });
        }

        public void cancel() {
            this.cancelled = true;
            this.future.cancel(true);
            this.client.close();
            this.rowQueue.clear();
        }

        @VisibleForTesting
        Future<?> getFuture() {
            return this.future;
        }

        @VisibleForTesting
        boolean isBackgroundThreadFinished() {
            return this.finished;
        }

        @Override
        protected T computeNext() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                this.handleInterrupt(e);
            }
            if (this.rowQueue.isEmpty()) {
                try {
                    this.future.get();
                }
                catch (InterruptedException e) {
                    this.handleInterrupt(e);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked(e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                return this.endOfData();
            }
            return (T)this.rowQueue.poll();
        }

        private void handleInterrupt(InterruptedException e) {
            this.cancel();
            Thread.currentThread().interrupt();
            throw new RuntimeException(new SQLException("Interrupted", e));
        }
    }

    private static class ResultsPageIterator
    extends AbstractIterator<Iterable<List<Object>>> {
        private final DatabendClient client;

        private ResultsPageIterator(DatabendClient client) {
            this.client = client;
        }

        @Override
        protected Iterable<List<Object>> computeNext() {
            QueryResults results;
            while (this.client.isRunning()) {
                results = this.client.getResults();
                Iterable<List<Object>> rows = results.getData();
                try {
                    this.client.next();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(e);
                }
                if (rows == null) continue;
                return rows;
            }
            results = this.client.getResults();
            if (results.getError() != null) {
                throw new RuntimeException(AbstractDatabendResultSet.resultsException(results));
            }
            return (Iterable)this.endOfData();
        }
    }
}

