/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.cloud;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.checkerframework.checker.nullness.qual.NonNull;

class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType contentType;
    private final long fileSize;

    public InputStreamRequestBody(MediaType contentType, InputStream inputStream2, long fileSize) {
        if (inputStream2 == null) {
            throw new NullPointerException("inputStream == null");
        }
        this.contentType = contentType;
        this.inputStream = inputStream2;
        this.fileSize = fileSize;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public long contentLength() throws IOException {
        return this.inputStream.available() == 0 ? -1L : (long)this.inputStream.available();
    }

    @Override
    public void writeTo(@NonNull BufferedSink sink2) throws IOException {
        try (Source source2 = Okio.source(this.inputStream);){
            sink2.writeAll(source2);
        }
        catch (IOException e) {
            throw new IOException("writeTo failed", e);
        }
    }
}

