/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.fastjson.FastjsonArray;
import java.util.Set;

public class FastjsonMapper
implements Mapper {
    private final JSONObject json;

    public FastjsonMapper(JSONObject json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(String key) {
        JSONObject subJson = this.json.getJSONObject(key);
        if (subJson != null) {
            return new FastjsonMapper(subJson);
        }
        return null;
    }

    public Array getArray(String key) {
        JSONArray subJson = this.json.getJSONArray(key);
        if (subJson != null) {
            return new FastjsonArray(subJson);
        }
        return null;
    }

    public boolean getBool(String key) {
        return this.json.getBooleanValue(key);
    }

    public int getInt(String key) {
        return this.json.getIntValue(key);
    }

    public long getLong(String key) {
        return this.json.getLongValue(key);
    }

    public float getFloat(String key) {
        return this.json.getFloatValue(key);
    }

    public double getDouble(String key) {
        return this.json.getDoubleValue(key);
    }

    public String getString(String key) {
        return this.json.getString(key);
    }

    public boolean has(String key) {
        return this.json.containsKey((Object)key);
    }

    public Set<String> keySet() {
        return this.json.keySet();
    }

    public String toString() {
        return this.json.toJSONString();
    }
}

