/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data.jackson;

import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.jackson.JacksonMapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class JacksonArray
implements Array {
    private final ArrayNode json;

    public JacksonArray(ArrayNode json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isObject()) {
            return new JacksonMapper((ObjectNode)subJson);
        }
        return null;
    }

    public Array getArray(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isArray()) {
            return new JacksonArray((ArrayNode)subJson);
        }
        return null;
    }

    public boolean getBool(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asBoolean(false);
        }
        return false;
    }

    public int getInt(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asInt(0);
        }
        return 0;
    }

    public long getLong(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asLong(0L);
        }
        return 0L;
    }

    public float getFloat(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isNumber()) {
            return subJson.floatValue();
        }
        if (subJson != null) {
            return (float)subJson.asDouble(0.0);
        }
        return 0.0f;
    }

    public double getDouble(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asDouble(0.0);
        }
        return 0.0;
    }

    public String getString(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asText();
        }
        return null;
    }

    public String toString() {
        return this.json.toString();
    }
}

