/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data.jackson;

import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.jackson.JacksonArray;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JacksonMapper
implements Mapper {
    private final ObjectNode json;

    public JacksonMapper(ObjectNode json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isObject()) {
            return new JacksonMapper((ObjectNode)subJson);
        }
        return null;
    }

    public Array getArray(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isArray()) {
            return new JacksonArray((ArrayNode)subJson);
        }
        return null;
    }

    public boolean getBool(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asBoolean(false);
        }
        return false;
    }

    public int getInt(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asInt(0);
        }
        return 0;
    }

    public long getLong(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asLong(0L);
        }
        return 0L;
    }

    public float getFloat(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isNumber()) {
            return subJson.floatValue();
        }
        if (subJson != null) {
            return (float)subJson.asDouble(0.0);
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asDouble(0.0);
        }
        return 0.0;
    }

    public String getString(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asText();
        }
        return null;
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public Set<String> keySet() {
        Iterator it = this.json.fieldNames();
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            set.add((String)it.next());
        }
        return set;
    }

    public String toString() {
        return this.json.toString();
    }
}

