/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.Download;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.OkHttpsException;
import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Process;
import com.ejlchina.okhttps.TaskExecutor;
import com.ejlchina.okhttps.internal.AbstractBody;
import com.ejlchina.okhttps.internal.ProcessInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.ByteString;

public class ResultBody
extends AbstractBody
implements HttpResult.Body {
    private final Response response;
    private boolean onIO = false;
    private OnCallback<Process> onProcess;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private boolean rangeIgnored = false;
    private final HttpTask<?> httpTask;
    private boolean cached = false;
    private byte[] data;

    ResultBody(HttpTask<?> httpTask, Response response, TaskExecutor taskExecutor) {
        super(taskExecutor, httpTask.charset(response));
        this.httpTask = httpTask;
        this.response = response;
    }

    @Override
    public MediaType getType() {
        ResponseBody body = this.response.body();
        if (body != null) {
            return body.contentType();
        }
        return null;
    }

    @Override
    public long getLength() {
        ResponseBody body = this.response.body();
        if (body != null) {
            return body.contentLength();
        }
        return 0L;
    }

    @Override
    public HttpResult.Body nextOnIO() {
        this.onIO = true;
        return this;
    }

    @Override
    public HttpResult.Body setOnProcess(OnCallback<Process> onProcess) {
        if (this.taskExecutor == null) {
            this.response.close();
            throw new IllegalStateException("\u6ca1\u6709 taskExecutor\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e0b\u8f7d\u8fdb\u5ea6\u56de\u8c03\uff01");
        }
        if (this.cached) {
            this.response.close();
            throw new IllegalStateException("\u5f00\u542f\u7f13\u5b58\u540e\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e0b\u8f7d\u8fdb\u5ea6\u56de\u8c03\uff01");
        }
        this.onProcess = onProcess;
        return this;
    }

    @Override
    public HttpResult.Body stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return this;
    }

    @Override
    public HttpResult.Body stepRate(double stepRate) {
        this.stepRate = stepRate;
        return this;
    }

    @Override
    public HttpResult.Body setRangeIgnored() {
        this.rangeIgnored = true;
        return this;
    }

    @Override
    protected InputStream convertingStream() {
        if (this.taskExecutor.isMulitMsgConvertor()) {
            this.cache();
        }
        return this.toByteStream();
    }

    @Override
    public InputStream toByteStream() {
        ResponseBody body;
        InputStream input = this.cached ? new ByteArrayInputStream(this.cacheBytes()) : ((body = this.response.body()) != null ? body.byteStream() : new ByteArrayInputStream(new byte[0]));
        if (this.onProcess != null) {
            long rangeStart = this.getRangeStart();
            long totalBytes = this.getLength();
            if (!this.rangeIgnored) {
                totalBytes += rangeStart;
            }
            if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                this.stepBytes = (long)((double)totalBytes * this.stepRate);
            }
            if (this.stepBytes <= 0L) {
                this.stepBytes = 8192L;
            }
            return new ProcessInputStream(input, this.onProcess, totalBytes, this.stepBytes, this.rangeIgnored ? 0L : rangeStart, this.taskExecutor.getExecutor(this.onIO));
        }
        return input;
    }

    @Override
    public byte[] toBytes() {
        if (this.cached) {
            return this.cacheBytes();
        }
        return this.bodyToBytes();
    }

    @Override
    public Reader toCharStream() {
        if (this.cached || this.onProcess != null) {
            return new InputStreamReader(this.toByteStream());
        }
        ResponseBody body = this.response.body();
        if (body != null) {
            return body.charStream();
        }
        return new CharArrayReader(new char[0]);
    }

    @Override
    public String toString() {
        if (this.cached || this.onProcess != null) {
            return new String(this.toBytes(), this.charset);
        }
        try {
            ResponseBody body = this.response.body();
            if (body != null) {
                return new String(body.bytes(), this.charset);
            }
        }
        catch (IOException e) {
            this.response.close();
            throw new OkHttpsException("\u62a5\u6587\u4f53\u8f6c\u5316\u5b57\u7b26\u4e32\u51fa\u9519", e);
        }
        return null;
    }

    @Override
    public ByteString toByteString() {
        return ByteString.of((byte[])this.toBytes());
    }

    @Override
    public Download toFile(String filePath) {
        return this.toFile(new File(filePath));
    }

    @Override
    public Download toFile(File file) {
        try {
            if (this.taskExecutor == null) {
                throw new IllegalStateException("\u6ca1\u6709 taskExecutor\uff0c \u4e0d\u53ef\u8fdb\u884c\u4e0b\u8f7d\u64cd\u4f5c\uff01");
            }
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (parent == null) {
                    throw new IllegalStateException("\u4e0d\u6b63\u786e\u7684\u4e0b\u8f7d\u8def\u5f84\uff1a" + file.getPath());
                }
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IllegalStateException("\u4e0d\u80fd\u521b\u5efa\u7236\u76ee\u5f55\uff1a" + parent.getPath());
                }
                if (!file.createNewFile()) {
                    throw new IllegalStateException("\u6587\u4ef6\u521a\u88ab\u5176\u5b83\u7ebf\u7a0b\u5360\u7528\uff1a" + parent.getPath());
                }
            }
        }
        catch (Exception e) {
            this.response.close();
            throw new OkHttpsException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
        }
        return this.taskExecutor.download(this.httpTask, file, this.toByteStream(), this.getRangeStart());
    }

    @Override
    public Download toFolder(String dirPath) {
        String fileName = this.resolveFileName();
        String filePath = this.resolveFilePath(dirPath, fileName);
        int index = 0;
        File file = new File(filePath);
        while (file.exists()) {
            String indexFileName = this.indexFileName(fileName, index++);
            filePath = this.resolveFilePath(dirPath, indexFileName);
            file = new File(filePath);
        }
        return this.toFile(file);
    }

    @Override
    public Download toFolder(File dir) {
        try {
            if (dir.exists() && !dir.isDirectory()) {
                throw new IllegalStateException("\u6587\u4ef6[" + dir.getPath() + "]\u5df2\u5b58\u5728\uff0c\u5e76\u4e14\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
            }
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalStateException("\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55\uff1a" + dir.getPath());
            }
        }
        catch (Exception e) {
            this.response.close();
            throw new OkHttpsException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25", e);
        }
        return this.toFolder(dir.getAbsolutePath());
    }

    @Override
    public HttpResult.Body cache() {
        if (this.onProcess != null) {
            this.response.close();
            throw new IllegalStateException("\u8bbe\u7f6e\u4e86\u4e0b\u8f7d\u8fdb\u5ea6\u56de\u8c03\uff0c\u4e0d\u53ef\u518d\u5f00\u542f\u7f13\u5b58\uff01");
        }
        this.cached = true;
        return this;
    }

    @Override
    public HttpResult.Body close() {
        this.response.close();
        this.data = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cacheBytes() {
        Response response = this.response;
        synchronized (response) {
            if (this.data == null) {
                this.data = this.bodyToBytes();
            }
        }
        return this.data;
    }

    private byte[] bodyToBytes() {
        if (this.onProcess != null) {
            try {
                byte[] byArray;
                Buffer buffer = new Buffer();
                try {
                    byArray = buffer.readFrom(this.toByteStream()).readByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OkHttpsException("\u62a5\u6587\u4f53\u8f6c\u5316\u5b57\u8282\u6570\u7ec4\u51fa\u9519", e);
                    }
                }
                buffer.close();
                return byArray;
            }
            finally {
                this.response.close();
            }
        }
        ResponseBody body = this.response.body();
        if (body != null) {
            try {
                return body.bytes();
            }
            catch (IOException e) {
                body.close();
                throw new OkHttpsException("\u62a5\u6587\u4f53\u8f6c\u5316\u5b57\u8282\u6570\u7ec4\u51fa\u9519", e);
            }
        }
        return new byte[0];
    }

    private long getRangeStart() {
        int index;
        long rangeStart = 0L;
        if (this.response.code() != 206) {
            return rangeStart;
        }
        String range = this.response.header("Content-Range");
        if (range != null && range.startsWith("bytes") && (index = range.indexOf(45)) > 5) {
            String start = range.substring(5, index).trim();
            try {
                rangeStart = Long.parseLong(start);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rangeStart;
    }

    private String resolveFilePath(String dirPath, String fileName) {
        if (dirPath.endsWith("\\") || dirPath.endsWith("/")) {
            return dirPath + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    private String indexFileName(String fileName, int index) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName + "(" + index + ")";
        }
        String ext = fileName.substring(i);
        if (i > 0) {
            String name = fileName.substring(0, i);
            return name + "(" + index + ")" + ext;
        }
        return "(" + index + ")" + ext;
    }

    private String resolveFileName() {
        String fileName = this.response.header("Content-Disposition");
        if (fileName == null || fileName.length() < 1) {
            fileName = this.response.request().url().encodedPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        } else {
            try {
                fileName = URLDecoder.decode(fileName.substring(fileName.indexOf("filename=") + 9), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.response.close();
                throw new OkHttpsException("\u89e3\u7801\u6587\u4ef6\u540d\u5931\u8d25", e);
            }
            fileName = fileName.replaceAll("\"", "");
        }
        return fileName;
    }
}

