/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.DecayRpcSchedulerMXBean;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.RpcScheduler;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.metrics2.util.MBeans;
import org.codehaus.jackson.map.ObjectMapper;

public class DecayRpcScheduler
implements RpcScheduler,
DecayRpcSchedulerMXBean {
    public static final String IPC_CALLQUEUE_DECAYSCHEDULER_PERIOD_KEY = "faircallqueue.decay-scheduler.period-ms";
    public static final long IPC_CALLQUEUE_DECAYSCHEDULER_PERIOD_DEFAULT = 5000L;
    public static final String IPC_CALLQUEUE_DECAYSCHEDULER_FACTOR_KEY = "faircallqueue.decay-scheduler.decay-factor";
    public static final double IPC_CALLQUEUE_DECAYSCHEDULER_FACTOR_DEFAULT = 0.5;
    public static final String IPC_CALLQUEUE_DECAYSCHEDULER_THRESHOLDS_KEY = "faircallqueue.decay-scheduler.thresholds";
    public static final String DECAYSCHEDULER_UNKNOWN_IDENTITY = "IdentityProvider.Unknown";
    public static final Log LOG = LogFactory.getLog(DecayRpcScheduler.class);
    private final ConcurrentHashMap<Object, AtomicLong> callCounts = new ConcurrentHashMap();
    private final AtomicLong totalCalls = new AtomicLong();
    private final AtomicReference<Map<Object, Integer>> scheduleCacheRef = new AtomicReference();
    private final long decayPeriodMillis;
    private final double decayFactor;
    private final int numQueues;
    private final double[] thresholds;
    private final IdentityProvider identityProvider;

    public DecayRpcScheduler(int numQueues, String ns, Configuration conf) {
        if (numQueues < 1) {
            throw new IllegalArgumentException("number of queues must be > 0");
        }
        this.numQueues = numQueues;
        this.decayFactor = DecayRpcScheduler.parseDecayFactor(ns, conf);
        this.decayPeriodMillis = DecayRpcScheduler.parseDecayPeriodMillis(ns, conf);
        this.identityProvider = this.parseIdentityProvider(ns, conf);
        this.thresholds = DecayRpcScheduler.parseThresholds(ns, conf, numQueues);
        Timer timer = new Timer();
        DecayTask task = new DecayTask(this, timer);
        timer.scheduleAtFixedRate((TimerTask)task, 0L, this.decayPeriodMillis);
        MetricsProxy prox = MetricsProxy.getInstance(ns);
        prox.setDelegate(this);
    }

    private IdentityProvider parseIdentityProvider(String ns, Configuration conf) {
        List<IdentityProvider> providers = conf.getInstances(ns + "." + "identity-provider.impl", IdentityProvider.class);
        if (providers.size() < 1) {
            LOG.info("IdentityProvider not specified, defaulting to UserIdentityProvider");
            return new UserIdentityProvider();
        }
        return providers.get(0);
    }

    private static double parseDecayFactor(String ns, Configuration conf) {
        double factor = conf.getDouble(ns + "." + IPC_CALLQUEUE_DECAYSCHEDULER_FACTOR_KEY, 0.5);
        if (factor <= 0.0 || factor >= 1.0) {
            throw new IllegalArgumentException("Decay Factor must be between 0 and 1");
        }
        return factor;
    }

    private static long parseDecayPeriodMillis(String ns, Configuration conf) {
        long period = conf.getLong(ns + "." + IPC_CALLQUEUE_DECAYSCHEDULER_PERIOD_KEY, 5000L);
        if (period <= 0L) {
            throw new IllegalArgumentException("Period millis must be >= 0");
        }
        return period;
    }

    private static double[] parseThresholds(String ns, Configuration conf, int numQueues) {
        int[] percentages = conf.getInts(ns + "." + IPC_CALLQUEUE_DECAYSCHEDULER_THRESHOLDS_KEY);
        if (percentages.length == 0) {
            return DecayRpcScheduler.getDefaultThresholds(numQueues);
        }
        if (percentages.length != numQueues - 1) {
            throw new IllegalArgumentException("Number of thresholds should be " + (numQueues - 1) + ". Was: " + percentages.length);
        }
        double[] decimals = new double[percentages.length];
        for (int i = 0; i < percentages.length; ++i) {
            decimals[i] = (double)percentages[i] / 100.0;
        }
        return decimals;
    }

    private static double[] getDefaultThresholds(int numQueues) {
        double[] ret = new double[numQueues - 1];
        double div = Math.pow(2.0, numQueues - 1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.pow(2.0, i) / div;
        }
        return ret;
    }

    private void decayCurrentCounts() {
        long total = 0L;
        Iterator<Map.Entry<Object, AtomicLong>> it = this.callCounts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, AtomicLong> entry = it.next();
            AtomicLong count = entry.getValue();
            long currentValue = count.get();
            long nextValue = (long)((double)currentValue * this.decayFactor);
            total += nextValue;
            count.set(nextValue);
            if (nextValue != 0L) continue;
            it.remove();
        }
        this.totalCalls.set(total);
        this.recomputeScheduleCache();
    }

    private void recomputeScheduleCache() {
        HashMap<Object, Integer> nextCache = new HashMap<Object, Integer>();
        for (Map.Entry<Object, AtomicLong> entry : this.callCounts.entrySet()) {
            Object id = entry.getKey();
            AtomicLong value = entry.getValue();
            long snapshot = value.get();
            int computedLevel = this.computePriorityLevel(snapshot);
            nextCache.put(id, computedLevel);
        }
        this.scheduleCacheRef.set(Collections.unmodifiableMap(nextCache));
    }

    private long getAndIncrement(Object identity) throws InterruptedException {
        AtomicLong otherCount;
        AtomicLong count = this.callCounts.get(identity);
        if (count == null && (otherCount = this.callCounts.putIfAbsent(identity, count = new AtomicLong(0L))) != null) {
            count = otherCount;
        }
        this.totalCalls.getAndIncrement();
        return count.getAndIncrement();
    }

    private int computePriorityLevel(long occurrences) {
        long totalCallSnapshot = this.totalCalls.get();
        double proportion = 0.0;
        if (totalCallSnapshot > 0L) {
            proportion = (double)occurrences / (double)totalCallSnapshot;
        }
        for (int i = this.numQueues - 1; i > 0; --i) {
            if (!(proportion >= this.thresholds[i - 1])) continue;
            return i;
        }
        return 0;
    }

    private int cachedOrComputedPriorityLevel(Object identity) {
        try {
            Integer priority;
            long occurrences = this.getAndIncrement(identity);
            Map<Object, Integer> scheduleCache = this.scheduleCacheRef.get();
            if (scheduleCache != null && (priority = scheduleCache.get(identity)) != null) {
                return priority;
            }
            return this.computePriorityLevel(occurrences);
        }
        catch (InterruptedException ie) {
            LOG.warn("Caught InterruptedException, returning low priority queue");
            return this.numQueues - 1;
        }
    }

    @Override
    public int getPriorityLevel(Schedulable obj) {
        String identity = this.identityProvider.makeIdentity(obj);
        if (identity == null) {
            identity = DECAYSCHEDULER_UNKNOWN_IDENTITY;
        }
        return this.cachedOrComputedPriorityLevel(identity);
    }

    @.VisibleForTesting
    public double getDecayFactor() {
        return this.decayFactor;
    }

    @.VisibleForTesting
    public long getDecayPeriodMillis() {
        return this.decayPeriodMillis;
    }

    @.VisibleForTesting
    public double[] getThresholds() {
        return this.thresholds;
    }

    @.VisibleForTesting
    public void forceDecay() {
        this.decayCurrentCounts();
    }

    @.VisibleForTesting
    public Map<Object, Long> getCallCountSnapshot() {
        HashMap<Object, Long> snapshot = new HashMap<Object, Long>();
        for (Map.Entry<Object, AtomicLong> entry : this.callCounts.entrySet()) {
            snapshot.put(entry.getKey(), entry.getValue().get());
        }
        return Collections.unmodifiableMap(snapshot);
    }

    @.VisibleForTesting
    public long getTotalCallSnapshot() {
        return this.totalCalls.get();
    }

    @Override
    public int getUniqueIdentityCount() {
        return this.callCounts.size();
    }

    @Override
    public long getTotalCallVolume() {
        return this.totalCalls.get();
    }

    @Override
    public String getSchedulingDecisionSummary() {
        Map<Object, Integer> decisions = this.scheduleCacheRef.get();
        if (decisions == null) {
            return "{}";
        }
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(decisions);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    @Override
    public String getCallVolumeSummary() {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(this.callCounts);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    private static final class MetricsProxy
    implements DecayRpcSchedulerMXBean {
        private static final HashMap<String, MetricsProxy> INSTANCES = new HashMap();
        private WeakReference<DecayRpcScheduler> delegate;

        private MetricsProxy(String namespace) {
            MBeans.register(namespace, "DecayRpcScheduler", this);
        }

        public static synchronized MetricsProxy getInstance(String namespace) {
            MetricsProxy mp = INSTANCES.get(namespace);
            if (mp == null) {
                mp = new MetricsProxy(namespace);
                INSTANCES.put(namespace, mp);
            }
            return mp;
        }

        public void setDelegate(DecayRpcScheduler obj) {
            this.delegate = new WeakReference<DecayRpcScheduler>(obj);
        }

        @Override
        public String getSchedulingDecisionSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getSchedulingDecisionSummary();
        }

        @Override
        public String getCallVolumeSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getCallVolumeSummary();
        }

        @Override
        public int getUniqueIdentityCount() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1;
            }
            return scheduler.getUniqueIdentityCount();
        }

        @Override
        public long getTotalCallVolume() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1L;
            }
            return scheduler.getTotalCallVolume();
        }
    }

    public static class DecayTask
    extends TimerTask {
        private WeakReference<DecayRpcScheduler> schedulerRef;
        private Timer timer;

        public DecayTask(DecayRpcScheduler scheduler, Timer timer) {
            this.schedulerRef = new WeakReference<DecayRpcScheduler>(scheduler);
            this.timer = timer;
        }

        @Override
        public void run() {
            DecayRpcScheduler sched = (DecayRpcScheduler)this.schedulerRef.get();
            if (sched != null) {
                sched.decayCurrentCounts();
            } else {
                this.timer.cancel();
                this.timer.purge();
            }
        }
    }
}

