/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.cache.service;

import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.JsonUtils;
import com.fhs.trans.service.impl.RpcTransService;
import com.fhs.trans.service.impl.SimpleTransService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class TransCacheManager {
    @Autowired(required=false)
    private RpcTransService rpcTransService;
    @Autowired(required=false)
    private SimpleTransService simpleTransService;
    @Autowired(required=false)
    private RedisCacheService<String> redisCacheService;

    public void clearCache(Class targetClass, Object pkey) {
        if (this.simpleTransService != null) {
            this.simpleTransService.clearGlobalCache(pkey, targetClass.getName(), "simple");
        }
        if (this.rpcTransService != null) {
            this.rpcTransService.clearGlobalCache(pkey, targetClass.getName(), "rpc");
        }
        if (this.redisCacheService != null) {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("messageType", "clear");
            body.put("target", targetClass.getName());
            body.put("pkey", ConverterUtils.toString(pkey));
            body.put("transType", "simple");
            this.redisCacheService.convertAndSend("trans", JsonUtils.map2json(body));
            body.put("transType", "rpc");
            this.redisCacheService.convertAndSend("trans", JsonUtils.map2json(body));
        }
    }

    public void setRpcTransCache(String targetClassName, SimpleTransService.TransCacheSett cacheSett) {
        this.rpcTransService.setTransCache(targetClassName, cacheSett);
    }
}

