/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.manager.ClassInfo;
import com.fhs.trans.manager.ClassManager;
import com.fhs.trans.service.impl.ITransTypeService;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class TransService {
    private static Logger logger = LoggerFactory.getLogger(TransService.class);
    private static Map<String, ITransTypeService> transTypeServiceMap = new LinkedHashMap<String, ITransTypeService>();

    public static void registerTransType(String type, ITransTypeService transTypeService) {
        transTypeServiceMap.put(type, transTypeService);
    }

    public void transOne(VO obj) {
        this.transOne(obj, null, null);
    }

    public void transOne(VO obj, Set<String> includeFields, Set<String> excludeFields) {
        if (obj == null) {
            return;
        }
        this.trans(null, obj, includeFields, excludeFields);
    }

    public void transMore(List<? extends VO> objList) {
        this.transMore(objList, null, null);
    }

    public void transMore(List<? extends VO> objList, Set<String> includeFields, Set<String> excludeFields) {
        if (objList == null || objList.size() == 0) {
            return;
        }
        this.trans(objList, null, includeFields, excludeFields);
    }

    private void trans(List<? extends VO> objList, VO obj, Set<String> includeFields, Set<String> excludeFields) {
        ClassInfo info = ClassManager.getClassInfoByName(obj != null ? obj.getClass() : objList.get(0).getClass());
        if (info.getTransTypes() == null) {
            return;
        }
        HashSet<String> transTypes = new HashSet<String>(Arrays.asList(info.getTransTypes()));
        List<Field> tempTransFieldList = null;
        List<Object> transFieldList = null;
        for (String type : transTypeServiceMap.keySet()) {
            if (!transTypes.contains(type)) continue;
            tempTransFieldList = info.getTransField(type);
            transFieldList = includeFields != null ? tempTransFieldList.stream().filter(field -> includeFields.contains(field.getName())).collect(Collectors.toList()) : (excludeFields != null ? tempTransFieldList.stream().filter(field -> !excludeFields.contains(field.getName())).collect(Collectors.toList()) : tempTransFieldList);
            if (transFieldList == null || transFieldList.size() == 0) continue;
            transFieldList.sort(new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getAnnotation(Trans.class).sort() - o2.getAnnotation(Trans.class).sort();
                }
            });
            ITransTypeService transTypeService = transTypeServiceMap.get(type);
            if (ObjectUtils.isEmpty((Object)transTypeService)) {
                logger.warn("\u6ca1\u6709\u5339\u914d\u7684\u8f6c\u6362\u5668:" + type);
                continue;
            }
            if (objList != null) {
                transTypeService.transMore(objList, transFieldList);
                continue;
            }
            transTypeService.transOne(obj, transFieldList);
        }
    }

    public void transBatch(List<? extends VO> objList) {
        this.transMore(objList);
    }
}

