/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.loop;

import com.gettyio.core.buffer.ChannelByteBuffer;
import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.buffer.NioBufferWriter;
import com.gettyio.core.channel.NioChannel;
import com.gettyio.core.channel.config.BaseConfig;
import com.gettyio.core.channel.loop.EventLoop;
import com.gettyio.core.channel.loop.SelectedSelector;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.ThreadPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioEventLoop
implements EventLoop {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(NioEventLoop.class);
    private boolean shutdown = false;
    private BaseConfig config;
    private SelectedSelector selector;
    private ThreadPool workerThreadPool;
    protected ChunkPool chunkPool;
    protected NioBufferWriter nioBufferWriter;
    protected ChannelByteBuffer writeByteBuffer;

    public NioEventLoop(BaseConfig config, ChunkPool chunkPool) {
        this.config = config;
        this.chunkPool = chunkPool;
        this.workerThreadPool = new ThreadPool(0, 2);
        this.nioBufferWriter = new NioBufferWriter(chunkPool, config.getBufferWriterQueueSize(), config.getChunkPoolBlockTime());
        try {
            this.selector = new SelectedSelector(Selector.open());
        }
        catch (IOException e) {
            LOGGER.error("selector init exception", e);
        }
    }

    @Override
    public void run() {
        this.workerThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                while (!NioEventLoop.this.shutdown) {
                    try {
                        NioEventLoop.this.selector.select();
                    }
                    catch (IOException e) {
                        LOGGER.error(e);
                    }
                    Iterator<SelectionKey> it = NioEventLoop.this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        ByteBuffer readBuffer;
                        NioChannel nioChannel;
                        block13: {
                            SelectionKey sk = it.next();
                            Object obj = sk.attachment();
                            if (!(obj instanceof NioChannel)) continue;
                            nioChannel = (NioChannel)obj;
                            SocketChannel channel = (SocketChannel)sk.channel();
                            if (sk.isConnectable()) {
                                if (!channel.isConnectionPending()) continue;
                                try {
                                    channel.finishConnect();
                                    continue;
                                }
                                catch (IOException e) {
                                    LOGGER.error(e);
                                    nioChannel.close();
                                    break;
                                }
                            }
                            if (!sk.isReadable()) continue;
                            readBuffer = null;
                            try {
                                readBuffer = NioEventLoop.this.chunkPool.allocate(NioEventLoop.this.config.getReadBufferSize(), NioEventLoop.this.config.getChunkPoolBlockTime());
                                int reccount = channel.read(readBuffer);
                                if (reccount == -1) {
                                    NioEventLoop.this.chunkPool.deallocate(readBuffer);
                                    nioChannel.close();
                                }
                                break block13;
                            }
                            catch (Exception e) {
                                LOGGER.error(e);
                                if (null != readBuffer) {
                                    NioEventLoop.this.chunkPool.deallocate(readBuffer);
                                }
                                nioChannel.close();
                            }
                            break;
                        }
                        if (null != readBuffer) {
                            readBuffer.flip();
                            while (readBuffer.hasRemaining()) {
                                byte[] bytes = new byte[readBuffer.remaining()];
                                readBuffer.get(bytes, 0, bytes.length);
                                nioChannel.doRead(bytes);
                            }
                        }
                        NioEventLoop.this.chunkPool.deallocate(readBuffer);
                    }
                    it.remove();
                }
            }
        });
        this.workerThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                while (!NioEventLoop.this.shutdown) {
                    if (NioEventLoop.this.writeByteBuffer == null) {
                        NioEventLoop.this.writeByteBuffer = NioEventLoop.this.nioBufferWriter.poll();
                    } else if (!NioEventLoop.this.writeByteBuffer.getByteBuffer().hasRemaining()) {
                        NioEventLoop.this.chunkPool.deallocate(NioEventLoop.this.writeByteBuffer.getByteBuffer());
                        NioEventLoop.this.writeByteBuffer = NioEventLoop.this.nioBufferWriter.poll();
                    }
                    if (NioEventLoop.this.writeByteBuffer == null) continue;
                    try {
                        if (NioEventLoop.this.writeByteBuffer.getNioChannel().isInvalid()) {
                            NioEventLoop.this.chunkPool.deallocate(NioEventLoop.this.writeByteBuffer.getByteBuffer());
                            NioEventLoop.this.writeByteBuffer = null;
                            continue;
                        }
                        NioEventLoop.this.writeByteBuffer.getNioChannel().getSocketChannel().write(NioEventLoop.this.writeByteBuffer.getByteBuffer());
                    }
                    catch (IOException e) {
                        NioEventLoop.this.writeByteBuffer.getNioChannel().close();
                        NioEventLoop.this.chunkPool.deallocate(NioEventLoop.this.writeByteBuffer.getByteBuffer());
                        NioEventLoop.this.writeByteBuffer = null;
                        continue;
                    }
                    if (NioEventLoop.this.writeByteBuffer.getNioChannel().isKeepAlive()) continue;
                    NioEventLoop.this.writeByteBuffer.getNioChannel().close();
                    NioEventLoop.this.chunkPool.deallocate(NioEventLoop.this.writeByteBuffer.getByteBuffer());
                    NioEventLoop.this.writeByteBuffer = null;
                }
            }
        });
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.nioBufferWriter != null) {
            try {
                this.nioBufferWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.workerThreadPool.isShutDown()) {
            this.workerThreadPool.shutdown();
        }
    }

    @Override
    public SelectedSelector getSelector() {
        return this.selector;
    }

    @Override
    public NioBufferWriter getBufferWriter() {
        return this.nioBufferWriter;
    }
}

