/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.SpringPluginBootstrap;
import com.gitee.starblues.bootstrap.annotation.OneselfConfig;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.utils.AnnotationUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.ResourceUtils;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

class ConfigureMainPluginEnvironment {
    private final ProcessorContext processorContext;
    private final List<PropertySourceLoader> propertySourceLoaders;

    ConfigureMainPluginEnvironment(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.propertySourceLoaders = new ArrayList<PropertySourceLoader>(2);
        this.propertySourceLoaders.add((PropertySourceLoader)new YamlPropertySourceLoader());
        this.propertySourceLoaders.add((PropertySourceLoader)new PropertiesPropertySourceLoader());
    }

    void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        SpringPluginBootstrap springPluginBootstrap = this.processorContext.getSpringPluginBootstrap();
        OneselfConfig oneselfConfig = AnnotationUtils.findAnnotation(springPluginBootstrap.getClass(), OneselfConfig.class);
        if (oneselfConfig == null) {
            return;
        }
        String[] mainConfigFileName = oneselfConfig.mainConfigFileName();
        if (mainConfigFileName.length == 0) {
            return;
        }
        for (String fileName : mainConfigFileName) {
            this.load(environment, fileName);
        }
    }

    private void load(ConfigurableEnvironment environment, String fileName) {
        String fileSuffix = ResourceUtils.getFileSuffix((String)fileName);
        if (ObjectUtils.isEmpty((CharSequence)fileSuffix)) {
            return;
        }
        PropertySourceLoader sourceLoader = null;
        block2: for (PropertySourceLoader propertySourceLoader : this.propertySourceLoaders) {
            String[] fileExtensions;
            for (String fileExtension : fileExtensions = propertySourceLoader.getFileExtensions()) {
                if (!fileSuffix.equalsIgnoreCase(fileExtension)) continue;
                sourceLoader = propertySourceLoader;
                continue block2;
            }
        }
        if (sourceLoader == null) {
            return;
        }
        URL url = Objects.requireNonNull(ClassUtils.getDefaultClassLoader()).getResource(fileName);
        if (url == null) {
            return;
        }
        try {
            Path path = Paths.get(url.toURI());
            FileSystemResource resource = new FileSystemResource(path);
            List propertySources = sourceLoader.load(fileName, (Resource)resource);
            for (PropertySource propertySource : propertySources) {
                environment.getPropertySources().addFirst(propertySource);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

