/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.ConfigureMainPluginEnvironment;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.core.descriptor.InsidePluginDescriptor;
import com.gitee.starblues.utils.Assert;
import com.gitee.starblues.utils.FilesUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.PluginFileUtils;
import java.io.File;
import java.util.HashMap;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class ConfigurePluginEnvironment {
    private static final String PLUGIN_PROPERTY_NAME = "pluginPropertySources";
    private static final String SPRING_CONFIG_NAME = "spring.config.name";
    private static final String SPRING_CONFIG_LOCATION = "spring.config.location";
    private static final String SPRING_JMX_UNIQUE_NAMES = "spring.jmx.unique-names";
    private static final String SPRING_ADMIN_JMX_NAME = "spring.application.admin.jmx-name";
    private static final String SPRING_ADMIN_JMX_VALUE = "org.springframework.boot:type=Admin,name=";
    public static final String REGISTER_SHUTDOWN_HOOK_PROPERTY = "logging.register-shutdown-hook";
    public static final String MBEAN_DOMAIN_PROPERTY_NAME = "spring.liveBeansView.mbeanDomain";
    private final ProcessorContext processorContext;
    private final InsidePluginDescriptor pluginDescriptor;

    ConfigurePluginEnvironment(ProcessorContext processorContext) {
        this.processorContext = (ProcessorContext)Assert.isNotNull((Object)processorContext, (String)"processorContext \u4e0d\u80fd\u4e3a\u7a7a");
        this.pluginDescriptor = (InsidePluginDescriptor)Assert.isNotNull((Object)processorContext.getPluginDescriptor(), (String)"pluginDescriptor \u4e0d\u80fd\u4e3a\u7a7a");
    }

    void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        String configFileLocation;
        HashMap<String, Object> env = new HashMap<String, Object>();
        String pluginId = this.pluginDescriptor.getPluginId();
        String configFileName = this.pluginDescriptor.getConfigFileName();
        if (!ObjectUtils.isEmpty((CharSequence)configFileName)) {
            env.put(SPRING_CONFIG_NAME, PluginFileUtils.getFileName((String)configFileName));
        }
        if (!ObjectUtils.isEmpty((CharSequence)(configFileLocation = this.pluginDescriptor.getConfigFileLocation()))) {
            env.put(SPRING_CONFIG_LOCATION, this.getConfigFileLocation(configFileLocation));
        }
        env.put("plugin.enableStarter", false);
        env.put(SPRING_JMX_UNIQUE_NAMES, true);
        env.put(SPRING_ADMIN_JMX_NAME, SPRING_ADMIN_JMX_VALUE + pluginId);
        env.put(REGISTER_SHUTDOWN_HOOK_PROPERTY, false);
        env.put(MBEAN_DOMAIN_PROPERTY_NAME, pluginId);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(PLUGIN_PROPERTY_NAME, env));
        if (this.processorContext.runMode() == ProcessorContext.RunMode.ONESELF) {
            ConfigureMainPluginEnvironment configureMainPluginEnvironment = new ConfigureMainPluginEnvironment(this.processorContext);
            configureMainPluginEnvironment.configureEnvironment(environment, args);
        }
    }

    private String getConfigFileLocation(String configFileLocation) {
        String s = FilesUtils.resolveRelativePath((String)new File("").getAbsolutePath(), (String)configFileLocation);
        if (s.endsWith("/") || s.endsWith(File.separator)) {
            return s;
        }
        return s + File.separator;
    }
}

