/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.realize.PluginCloseListener;
import com.gitee.starblues.bootstrap.realize.StopValidator;
import com.gitee.starblues.bootstrap.utils.DestroyUtils;
import com.gitee.starblues.bootstrap.utils.SpringBeanUtils;
import com.gitee.starblues.core.descriptor.PluginDescriptor;
import com.gitee.starblues.core.exception.PluginProhibitStopException;
import com.gitee.starblues.spring.ApplicationContext;
import com.gitee.starblues.spring.ApplicationContextProxy;
import com.gitee.starblues.spring.SpringPluginHook;
import com.gitee.starblues.spring.WebConfig;
import com.gitee.starblues.spring.web.thymeleaf.ThymeleafConfig;
import java.util.List;
import java.util.Map;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class DefaultSpringPluginHook
implements SpringPluginHook {
    private final SpringPluginProcessor pluginProcessor;
    private final ProcessorContext processorContext;
    private final StopValidator stopValidator;

    public DefaultSpringPluginHook(SpringPluginProcessor pluginProcessor, ProcessorContext processorContext) {
        this.pluginProcessor = pluginProcessor;
        this.processorContext = processorContext;
        this.stopValidator = SpringBeanUtils.getExistBean((org.springframework.context.ApplicationContext)processorContext.getApplicationContext(), StopValidator.class);
    }

    public void stopVerify() {
        if (this.stopValidator == null) {
            return;
        }
        try {
            StopValidator.Result result = this.stopValidator.verify();
            if (result != null && !result.isVerify()) {
                throw new PluginProhibitStopException((PluginDescriptor)this.processorContext.getPluginDescriptor(), result.getMessage());
            }
        }
        catch (Exception e) {
            throw new PluginProhibitStopException((PluginDescriptor)this.processorContext.getPluginDescriptor(), e.getMessage());
        }
    }

    public void close() throws Exception {
        try {
            GenericApplicationContext applicationContext = this.processorContext.getApplicationContext();
            this.callPluginCloseListener(applicationContext);
            this.pluginProcessor.close(this.processorContext);
            if (applicationContext != null) {
                applicationContext.close();
            }
            this.processorContext.clearRegistryInfo();
            DestroyUtils.destroyAll(null, SpringFactoriesLoader.class, "cache", Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApplicationContext getApplicationContext() {
        return new ApplicationContextProxy((Object)this.processorContext.getApplicationContext().getBeanFactory());
    }

    public WebConfig getWebConfig() {
        return this.processorContext.getWebConfig();
    }

    public ThymeleafConfig getThymeleafConfig() {
        return (ThymeleafConfig)this.processorContext.getRegistryInfo("ThymeleafConfig");
    }

    private void callPluginCloseListener(GenericApplicationContext applicationContext) {
        List<PluginCloseListener> pluginCloseListeners = SpringBeanUtils.getBeans((org.springframework.context.ApplicationContext)applicationContext, PluginCloseListener.class);
        if (pluginCloseListeners.isEmpty()) {
            return;
        }
        for (PluginCloseListener pluginCloseListener : pluginCloseListeners) {
            try {
                pluginCloseListener.close((PluginDescriptor)this.processorContext.getPluginDescriptor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

