/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.utils.DestroyUtils;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.ReflectionUtils;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.lang.Nullable;

public class PluginListableBeanFactory
extends DefaultListableBeanFactory {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MainApplicationContext applicationContext;

    public PluginListableBeanFactory(MainApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object resolveDependency(DependencyDescriptor descriptor, @Nullable String requestingBeanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) throws BeansException {
        try {
            return super.resolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
        }
        catch (BeansException e) {
            return this.resolveDependencyFromMain(descriptor);
        }
    }

    private Object resolveDependencyFromMain(DependencyDescriptor descriptor) {
        String dependencyName = descriptor.getDependencyName();
        SpringBeanFactory springBeanFactory = this.applicationContext.getSpringBeanFactory();
        if (!ObjectUtils.isEmpty((CharSequence)dependencyName) && springBeanFactory.containsBean(dependencyName)) {
            return springBeanFactory.getBean(dependencyName);
        }
        try {
            return springBeanFactory.getBean(descriptor.getDependencyType());
        }
        catch (Exception e) {
            throw new NoSuchBeanDefinitionException(descriptor.getDependencyType());
        }
    }

    public void destroySingletons() {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = this.getBeanDefinitionNames()) {
            this.destroyBean(beanDefinitionName);
        }
        super.destroySingletons();
        this.destroyAll();
    }

    private void destroyAll() {
        ReflectionUtils.findField(((Object)((Object)this)).getClass(), field -> {
            field.setAccessible(true);
            try {
                Object o = field.get((Object)this);
                DestroyUtils.destroyAll(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return false;
        });
    }
}

