/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap;

import com.gitee.starblues.bootstrap.DefaultSpringPluginHook;
import com.gitee.starblues.bootstrap.PluginOneselfInteractive;
import com.gitee.starblues.bootstrap.PluginSpringApplication;
import com.gitee.starblues.bootstrap.processor.ComposeSpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.DefaultProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.core.launcher.plugin.PluginInteractive;
import com.gitee.starblues.spring.SpringPluginHook;
import java.util.ArrayList;
import java.util.List;

public abstract class SpringPluginBootstrap {
    private ProcessorContext.RunMode runMode = ProcessorContext.RunMode.ONESELF;
    private volatile PluginInteractive pluginInteractive;
    private final List<SpringPluginProcessor> customPluginProcessors = new ArrayList<SpringPluginProcessor>();

    public final SpringPluginHook run(String[] args) {
        return this.run(this.getClass(), args);
    }

    public final SpringPluginHook run(Class<?> primarySources, String[] args) {
        return this.run(new Class[]{primarySources}, args);
    }

    public final SpringPluginHook run(Class<?>[] primarySources, String[] args) {
        return this.start(primarySources, args);
    }

    private SpringPluginHook start(Class<?>[] primarySources, String[] args) {
        this.createPluginInteractive();
        this.addCustomSpringPluginProcessor();
        ComposeSpringPluginProcessor pluginProcessor = new ComposeSpringPluginProcessor(this.runMode, this.customPluginProcessors);
        DefaultProcessorContext processorContext = new DefaultProcessorContext(this.runMode, this, this.pluginInteractive, this.getClass());
        PluginSpringApplication springApplication = new PluginSpringApplication(pluginProcessor, processorContext, primarySources);
        springApplication.run(args);
        return new DefaultSpringPluginHook(pluginProcessor, processorContext);
    }

    public final SpringPluginBootstrap setPluginInteractive(PluginInteractive pluginInteractive) {
        this.pluginInteractive = pluginInteractive;
        this.runMode = ProcessorContext.RunMode.PLUGIN;
        return this;
    }

    public final SpringPluginBootstrap addSpringPluginProcessor(SpringPluginProcessor springPluginProcessor) {
        if (springPluginProcessor != null) {
            this.customPluginProcessors.add(springPluginProcessor);
        }
        return this;
    }

    protected final void createPluginInteractive() {
        if (this.pluginInteractive != null) {
            return;
        }
        this.createPluginInteractiveOfOneself();
    }

    protected final void createPluginInteractiveOfOneself() {
        this.pluginInteractive = new PluginOneselfInteractive();
    }

    protected void addCustomSpringPluginProcessor() {
    }
}

