/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor;

import com.gitee.starblues.bootstrap.SpringPluginBootstrap;
import com.gitee.starblues.bootstrap.annotation.DisablePluginWeb;
import com.gitee.starblues.bootstrap.processor.ExtractBeanProcessor;
import com.gitee.starblues.bootstrap.processor.FrameDefineBeanProcessor;
import com.gitee.starblues.bootstrap.processor.InvokeOtherPluginProcessor;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.web.PluginControllerProcessor;
import com.gitee.starblues.bootstrap.processor.web.PluginInterceptorsProcessor;
import com.gitee.starblues.bootstrap.processor.web.PluginSpringDocControllerProcessor;
import com.gitee.starblues.bootstrap.processor.web.PluginStaticResourceProcessor;
import com.gitee.starblues.bootstrap.processor.web.thymeleaf.PluginThymeleafProcessor;
import com.gitee.starblues.bootstrap.utils.AnnotationUtils;
import com.gitee.starblues.bootstrap.utils.ProcessorUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.OrderPriority;
import com.gitee.starblues.utils.OrderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposeSpringPluginProcessor
implements SpringPluginProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProcessorContext.RunMode runMode;
    private List<SpringPluginProcessor> processors;

    public ComposeSpringPluginProcessor(ProcessorContext.RunMode runMode) {
        this(runMode, null);
    }

    public ComposeSpringPluginProcessor(ProcessorContext.RunMode runMode, List<SpringPluginProcessor> processors) {
        this.runMode = runMode;
        this.processors = !ObjectUtils.isEmpty(processors) ? processors : new ArrayList<SpringPluginProcessor>();
    }

    public void addSpringPluginProcessor(SpringPluginProcessor springPluginProcessor) {
        if (springPluginProcessor != null) {
            this.processors.add(springPluginProcessor);
        }
    }

    @Override
    public void initialize(ProcessorContext context) throws ProcessorException {
        ArrayList<SpringPluginProcessor> processors = new ArrayList<SpringPluginProcessor>();
        this.addDefaultProcessors(context, processors);
        this.addDefaultWebEnvProcessors(context, processors);
        processors.addAll(this.processors);
        this.processors = processors.stream().filter(p -> {
            ProcessorContext.RunMode runMode = p.runMode();
            return runMode == ProcessorContext.RunMode.ALL || runMode == this.runMode;
        }).sorted(OrderUtils.orderPriority(SpringPluginProcessor::order)).collect(Collectors.toList());
        for (SpringPluginProcessor processor : this.processors) {
            try {
                processor.initialize(context);
            }
            catch (Throwable e) {
                this.processException(processor, "initialize", e, true);
            }
        }
    }

    @Override
    public void refreshBefore(ProcessorContext context) throws ProcessorException {
        for (SpringPluginProcessor processor : this.processors) {
            try {
                processor.refreshBefore(context);
            }
            catch (Throwable e) {
                this.processException(processor, "refreshBefore", e, true);
            }
        }
    }

    @Override
    public void refreshAfter(ProcessorContext context) throws ProcessorException {
        for (SpringPluginProcessor processor : this.processors) {
            try {
                processor.refreshAfter(context);
            }
            catch (Throwable e) {
                this.processException(processor, "refreshAfter", e, true);
            }
        }
    }

    @Override
    public void failure(ProcessorContext context) throws ProcessorException {
        for (SpringPluginProcessor processor : this.processors) {
            try {
                processor.failure(context);
            }
            catch (Throwable e) {
                this.processException(processor, "failure", e, false);
            }
        }
    }

    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        for (SpringPluginProcessor processor : this.processors) {
            try {
                processor.close(context);
            }
            catch (Throwable e) {
                this.processException(processor, "close", e, false);
            }
        }
    }

    @Override
    public OrderPriority order() {
        return OrderPriority.getHighPriority();
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.ALL;
    }

    protected void addDefaultProcessors(ProcessorContext context, List<SpringPluginProcessor> processors) {
        processors.add(new FrameDefineBeanProcessor());
        processors.add(new ExtractBeanProcessor());
        processors.add(new InvokeOtherPluginProcessor());
    }

    protected void addDefaultWebEnvProcessors(ProcessorContext context, List<SpringPluginProcessor> processors) {
        SpringPluginBootstrap springPluginBootstrap = context.getSpringPluginBootstrap();
        DisablePluginWeb disablePluginWeb = AnnotationUtils.findAnnotation(springPluginBootstrap.getClass(), DisablePluginWeb.class);
        if (disablePluginWeb != null) {
            return;
        }
        context.getWebConfig().setEnable(true);
        processors.add(new PluginControllerProcessor());
        processors.add(new PluginInterceptorsProcessor());
        processors.add(new PluginStaticResourceProcessor());
        processors.add(new PluginThymeleafProcessor());
        ProcessorUtils.add(processors, PluginSpringDocControllerProcessor::new);
    }

    private void processException(SpringPluginProcessor processor, String executeType, Throwable e, boolean isThrow) throws ProcessorException {
        String error = "Processor[" + processor.getClass().getName() + "] execute[" + executeType + "] failure : " + e.getMessage();
        this.logger.error(error, e);
        if (isThrow) {
            throw new ProcessorException(error, e);
        }
    }
}

