/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.realize.DefaultMainEnvironmentProvider;
import com.gitee.starblues.bootstrap.realize.EmptyMainEnvironmentProvider;
import com.gitee.starblues.bootstrap.realize.MainEnvironmentProvider;
import com.gitee.starblues.core.descriptor.InsidePluginDescriptor;
import com.gitee.starblues.integration.AutoIntegrationConfiguration;
import com.gitee.starblues.integration.ExtendPointConfiguration;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;

public class FrameDefineBeanProcessor
implements SpringPluginProcessor {
    @Override
    public void refreshBefore(ProcessorContext context) throws ProcessorException {
        GenericApplicationContext applicationContext = context.getApplicationContext();
        InsidePluginDescriptor pluginDescriptor = context.getPluginDescriptor();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerSingleton("pluginDescriptor", (Object)pluginDescriptor.toPluginDescriptor());
        beanFactory.registerSingleton("mainApplicationContext", (Object)context.getMainApplicationContext());
        MainEnvironmentProvider mainEnvironmentProvider = null;
        if (context.runMode() == ProcessorContext.RunMode.ONESELF) {
            beanFactory.registerSingleton("integrationConfiguration", (Object)new AutoIntegrationConfiguration());
            applicationContext.registerBean(ExtendPointConfiguration.class, new BeanDefinitionCustomizer[0]);
            mainEnvironmentProvider = new EmptyMainEnvironmentProvider();
        } else {
            mainEnvironmentProvider = new DefaultMainEnvironmentProvider(context.getMainApplicationContext());
        }
        beanFactory.registerSingleton("mainEnvironmentProvider", (Object)mainEnvironmentProvider);
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.ALL;
    }
}

