/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor;

import com.gitee.starblues.annotation.Caller;
import com.gitee.starblues.annotation.Supplier;
import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.processor.invoke.InvokeBeanFactory;
import com.gitee.starblues.bootstrap.processor.scanner.PluginClassPathBeanDefinitionScanner;
import com.gitee.starblues.spring.ApplicationContext;
import com.gitee.starblues.spring.ApplicationContextProxy;
import com.gitee.starblues.spring.invoke.InvokeSupperCache;
import com.gitee.starblues.spring.invoke.SupperCache;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.ScanUtils;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class InvokeOtherPluginProcessor
implements SpringPluginProcessor {
    @Override
    public void refreshBefore(ProcessorContext context) throws ProcessorException {
        InvokeCallerBeanDefinitionScanner scanner = new InvokeCallerBeanDefinitionScanner(context);
        scanner.doScan(ScanUtils.getScanBasePackages(context.getRunnerClass()));
    }

    @Override
    public void refreshAfter(ProcessorContext context) throws ProcessorException {
        GenericApplicationContext applicationContext = context.getApplicationContext();
        Map supplierBeans = applicationContext.getBeansWithAnnotation(Supplier.class);
        String pluginId = context.getPluginDescriptor().getPluginId();
        ApplicationContextProxy applicationContextReflection = new ApplicationContextProxy((Object)applicationContext);
        InvokeSupperCache invokeSupperCache = context.getPluginInteractive().getInvokeSupperCache();
        supplierBeans.forEach((arg_0, arg_1) -> InvokeOtherPluginProcessor.lambda$refreshAfter$0(invokeSupperCache, pluginId, (ApplicationContext)applicationContextReflection, arg_0, arg_1));
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.ALL;
    }

    private static /* synthetic */ void lambda$refreshAfter$0(InvokeSupperCache invokeSupperCache, String pluginId, ApplicationContext applicationContextReflection, String k, Object v) {
        Supplier supplier = (Supplier)AnnotationUtils.findAnnotation(v.getClass(), Supplier.class);
        String supperKey = k;
        if (supplier != null && !ObjectUtils.isEmpty((CharSequence)supplier.value())) {
            supperKey = supplier.value();
        }
        invokeSupperCache.add(pluginId, new SupperCache(supperKey, k, applicationContextReflection));
    }

    private static class InvokeCallerBeanDefinitionScanner
    extends PluginClassPathBeanDefinitionScanner {
        private final ProcessorContext context;

        public InvokeCallerBeanDefinitionScanner(ProcessorContext context) {
            super(context, false);
            this.setResourceLoader(context.getResourceLoader());
            this.context = context;
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Caller.class));
            this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
                String className = metadataReader.getClassMetadata().getClassName();
                return className.endsWith("package-info");
            });
        }

        protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
            Set holders = super.doScan(basePackages);
            ClassLoader pluginClassLoader = this.context.getClassLoader();
            InvokeSupperCache invokeSupperCache = this.context.getPluginInteractive().getInvokeSupperCache();
            for (BeanDefinitionHolder holder : holders) {
                AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
                try {
                    Class<?> aClass = pluginClassLoader.loadClass(definition.getBeanClassName());
                    Caller caller = (Caller)AnnotationUtils.findAnnotation(aClass, Caller.class);
                    if (caller == null) continue;
                    definition.getPropertyValues().add("callerAnnotation", (Object)caller);
                    definition.getPropertyValues().add("callerInterface", aClass);
                    definition.getPropertyValues().add("invokeSupperCache", (Object)invokeSupperCache);
                    definition.setBeanClass(InvokeBeanFactory.class);
                    definition.setAutowireMode(2);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return holders;
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
        }
    }
}

