/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.interceptor;

import com.gitee.starblues.bootstrap.processor.interceptor.PluginInterceptorRegistration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public class PluginInterceptorRegistry {
    private final List<PluginInterceptorRegistration> registrations = new ArrayList<PluginInterceptorRegistration>();
    private final String pluginRestApiPrefix;
    private static final Comparator<Object> INTERCEPTOR_ORDER_COMPARATOR = OrderComparator.INSTANCE.withSourceProvider(object -> {
        if (object instanceof PluginInterceptorRegistration) {
            return ((PluginInterceptorRegistration)object)::getOrder;
        }
        return null;
    });

    public PluginInterceptorRegistry(String pluginRestApiPrefix) {
        this.pluginRestApiPrefix = pluginRestApiPrefix;
    }

    public PluginInterceptorRegistration addInterceptor(HandlerInterceptor interceptor, Type type) {
        PluginInterceptorRegistration registration = new PluginInterceptorRegistration(interceptor, type, this.pluginRestApiPrefix);
        this.registrations.add(registration);
        return registration;
    }

    public PluginInterceptorRegistration addWebRequestInterceptor(WebRequestInterceptor interceptor, Type type) {
        WebRequestHandlerInterceptorAdapter adapted = new WebRequestHandlerInterceptorAdapter(interceptor);
        PluginInterceptorRegistration registration = new PluginInterceptorRegistration((HandlerInterceptor)adapted, type, this.pluginRestApiPrefix);
        this.registrations.add(registration);
        return registration;
    }

    public List<Object> getInterceptors() {
        return this.registrations.stream().sorted(INTERCEPTOR_ORDER_COMPARATOR).map(PluginInterceptorRegistration::getInterceptor).collect(Collectors.toList());
    }

    public static enum Type {
        GLOBAL,
        PLUGIN;

    }
}

