/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.invoke;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gitee.starblues.annotation.Caller;
import com.gitee.starblues.annotation.Supplier;
import com.gitee.starblues.spring.invoke.InvokeSupperCache;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;

public class InvokeProxyHandler
implements InvocationHandler {
    private final Caller callerAnnotation;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final InvokeSupperCache invokeSupperCache;

    public InvokeProxyHandler(Caller callerAnnotation, InvokeSupperCache invokeSupperCache) {
        this.callerAnnotation = callerAnnotation;
        this.invokeSupperCache = invokeSupperCache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] callerArgs) throws Throwable {
        String pluginId = this.callerAnnotation.pluginId();
        Object supplierObject = this.invokeSupperCache.getSupperBean(pluginId, this.callerAnnotation.value());
        if (supplierObject == null) {
            if (ObjectUtils.isEmpty((CharSequence)pluginId)) {
                throw new Exception("Not found '" + this.callerAnnotation.value() + "' supplier object");
            }
            throw new Exception("Not found '" + this.callerAnnotation.value() + "' supplier object in plugin '" + pluginId + "'");
        }
        Caller.Method callerMethod = method.getAnnotation(Caller.Method.class);
        if (callerArgs == null) {
            callerArgs = new Object[]{};
        }
        if (callerMethod == null) {
            return this.notAnnotationInvoke(method, supplierObject, callerArgs);
        }
        return this.annotationInvoke(method, callerMethod, supplierObject, callerArgs);
    }

    private Object annotationInvoke(Method method, Caller.Method callerMethod, Object supplierObject, Object[] callerArgs) throws Throwable {
        String callerMethodName = callerMethod.value();
        Class<?> supplierClass = supplierObject.getClass();
        Method[] methods = supplierClass.getMethods();
        Method supplierMethod = null;
        for (Method m : methods) {
            Supplier.Method supplierMethodAnnotation = m.getAnnotation(Supplier.Method.class);
            if (supplierMethodAnnotation == null || !Objects.equals(supplierMethodAnnotation.value(), callerMethodName)) continue;
            supplierMethod = m;
            break;
        }
        if (supplierMethod == null) {
            return this.notAnnotationInvoke(method, supplierObject, callerArgs);
        }
        Class<?>[] parameterTypes = supplierMethod.getParameterTypes();
        if (parameterTypes.length != callerArgs.length) {
            return this.notAnnotationInvoke(method, supplierObject, callerArgs);
        }
        Object[] supplierArgs = this.getSupplierArgs(callerArgs, supplierMethod);
        Object invokeReturn = supplierMethod.invoke(supplierObject, supplierArgs);
        return this.getReturnObject(invokeReturn, method);
    }

    private Object notAnnotationInvoke(Method method, Object supplierObject, Object[] callerArgs) throws Throwable {
        String name = method.getName();
        Class[] supplierArgClasses = new Class[callerArgs.length];
        ClassLoader classLoader = supplierObject.getClass().getClassLoader();
        for (int i = 0; i < callerArgs.length; ++i) {
            Object callerArg = callerArgs[i];
            try {
                supplierArgClasses[i] = classLoader.loadClass(callerArg.getClass().getName());
                continue;
            }
            catch (Exception e) {
                supplierArgClasses[i] = callerArg.getClass();
            }
        }
        Class<?> supplierClass = supplierObject.getClass();
        Method supplierMethod = null;
        try {
            supplierMethod = supplierClass.getMethod(name, supplierArgClasses);
        }
        catch (Exception e) {
            supplierMethod = this.findSupplierMethod(supplierClass, name, supplierArgClasses);
        }
        if (supplierMethod == null) {
            throw ReflectionUtils.getNoSuchMethodException(supplierClass, (String)name, (Class[])supplierArgClasses);
        }
        Object[] supplierArgs = this.getSupplierArgs(callerArgs, supplierMethod);
        Object invokeReturn = supplierMethod.invoke(supplierObject, supplierArgs);
        return this.getReturnObject(invokeReturn, method);
    }

    private Object[] getSupplierArgs(Object[] callerArgs, Method supplierMethod) throws Exception {
        if (callerArgs == null || callerArgs.length == 0) {
            return new Class[0];
        }
        Class<?>[] supplierParameterTypes = supplierMethod.getParameterTypes();
        Object[] supplierArgs = new Object[callerArgs.length];
        for (int i = 0; i < supplierParameterTypes.length; ++i) {
            Object serializeObject;
            Class<?> supplierParameterType = supplierParameterTypes[i];
            Object arg = callerArgs[i];
            if (supplierParameterType.isAssignableFrom(arg.getClass())) {
                supplierArgs[i] = arg;
                continue;
            }
            String json = OBJECT_MAPPER.writeValueAsString(arg);
            supplierArgs[i] = serializeObject = OBJECT_MAPPER.readValue(json, supplierParameterType);
        }
        return supplierArgs;
    }

    private Object getReturnObject(Object invokeReturn, Method method) throws Throwable {
        if (invokeReturn == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (invokeReturn.getClass().isAssignableFrom(returnType)) {
            return invokeReturn;
        }
        String json = OBJECT_MAPPER.writeValueAsString(invokeReturn);
        return OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.getTypeFactory().constructType(method.getGenericReturnType()));
    }

    private Method findSupplierMethod(Class<?> supplierClass, String methodName, Class<?>[] supplierArgClasses) {
        while (supplierClass != null) {
            Method[] methods;
            for (Method method : methods = supplierClass.getMethods()) {
                String name = method.getName();
                if (!Objects.equals(name, methodName) || method.getParameterTypes().length != supplierArgClasses.length) continue;
                return method;
            }
            supplierClass = supplierClass.getSuperclass();
        }
        return null;
    }
}

