/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web;

import com.gitee.starblues.bootstrap.processor.ProcessorContext;
import com.gitee.starblues.bootstrap.processor.ProcessorException;
import com.gitee.starblues.bootstrap.processor.SpringPluginProcessor;
import com.gitee.starblues.bootstrap.utils.AnnotationUtils;
import com.gitee.starblues.bootstrap.utils.DestroyUtils;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.spring.ApplicationContext;
import com.gitee.starblues.spring.SpringBeanFactory;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.ObjectUtils;
import com.gitee.starblues.utils.PluginConfigUtils;
import com.gitee.starblues.utils.ReflectionUtils;
import com.gitee.starblues.utils.SpringBeanCustomUtils;
import com.gitee.starblues.utils.UrlUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginControllerProcessor
implements SpringPluginProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PluginControllerProcessor.class);
    static final String PROCESS_CONTROLLERS = "PROCESS_SUCCESS";
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private Method getMappingForMethod;
    private RequestMappingHandlerAdapter handlerAdapter;
    private final AtomicBoolean canRegistered = new AtomicBoolean(false);

    @Override
    public void initialize(ProcessorContext processorContext) throws ProcessorException {
        SpringBeanFactory mainBeanFactory = processorContext.getMainBeanFactory();
        this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)mainBeanFactory.getBean(RequestMappingHandlerMapping.class);
        this.handlerAdapter = (RequestMappingHandlerAdapter)SpringBeanCustomUtils.getExistBean((ApplicationContext)processorContext.getMainApplicationContext(), RequestMappingHandlerAdapter.class);
        this.getMappingForMethod = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"getMappingForMethod", (Class[])new Class[]{Method.class, Class.class});
        if (this.getMappingForMethod == null) {
            LOG.warn("RequestMappingHandlerMapping \u7c7b\u4e2d\u6ca1\u6709\u53d1\u73b0 <getMappingForMethod> \u65b9\u6cd5, \u65e0\u6cd5\u6ce8\u518c\u63d2\u4ef6\u63a5\u53e3. \u8bf7\u68c0\u67e5\u5f53\u524d\u73af\u5883\u662f\u5426\u4e3a web \u73af\u5883");
        }
        this.getMappingForMethod.setAccessible(true);
        this.canRegistered.set(true);
    }

    @Override
    public void refreshBefore(ProcessorContext processorContext) throws ProcessorException {
        if (!this.canRegistered.get()) {
            return;
        }
        GenericApplicationContext applicationContext = processorContext.getApplicationContext();
        applicationContext.registerBean("changeRestPathPostProcessor", ChangeRestPathPostProcessor.class, () -> new ChangeRestPathPostProcessor(processorContext), new BeanDefinitionCustomizer[0]);
    }

    @Override
    public void refreshAfter(ProcessorContext processorContext) throws ProcessorException {
        if (!this.canRegistered.get()) {
            return;
        }
        IntegrationConfiguration configuration = processorContext.getConfiguration();
        if (ObjectUtils.isEmpty((CharSequence)configuration.pluginRestPathPrefix()) && !configuration.enablePluginIdRestPathPrefix()) {
            return;
        }
        String pluginId = processorContext.getPluginDescriptor().getPluginId();
        List controllerWrappers = (List)processorContext.getRegistryInfo(PROCESS_CONTROLLERS);
        if (ObjectUtils.isEmpty((Object)controllerWrappers)) {
            return;
        }
        GenericApplicationContext applicationContext = processorContext.getApplicationContext();
        Iterator iterator = controllerWrappers.iterator();
        while (iterator.hasNext()) {
            Object controllerBean;
            Set<RequestMappingInfo> requestMappingInfos;
            ControllerWrapper controllerWrapper = (ControllerWrapper)iterator.next();
            if (!applicationContext.containsBean(controllerWrapper.getBeanName())) {
                iterator.remove();
            }
            if ((requestMappingInfos = this.registry(applicationContext, (controllerBean = applicationContext.getBean(controllerWrapper.getBeanName())).getClass())).isEmpty()) {
                iterator.remove();
                continue;
            }
            for (RequestMappingInfo requestMappingInfo : requestMappingInfos) {
                LOG.info("\u63d2\u4ef6[{}]\u6ce8\u518c\u63a5\u53e3: {}", (Object)pluginId, (Object)requestMappingInfo.toString());
            }
            controllerWrapper.setRequestMappingInfos(requestMappingInfos);
        }
    }

    @Override
    public void close(ProcessorContext context) throws ProcessorException {
        List controllerWrappers = (List)context.getRegistryInfo(PROCESS_CONTROLLERS);
        if (ObjectUtils.isEmpty((Object)controllerWrappers)) {
            return;
        }
        for (ControllerWrapper controllerWrapper : controllerWrappers) {
            this.unregister(controllerWrapper);
        }
        controllerWrappers.clear();
    }

    @Override
    public ProcessorContext.RunMode runMode() {
        return ProcessorContext.RunMode.PLUGIN;
    }

    private Set<RequestMappingInfo> registry(GenericApplicationContext pluginApplicationContext, Class<?> aClass) throws ProcessorException {
        Object object = pluginApplicationContext.getBean(aClass);
        Method[] methods = aClass.getDeclaredMethods();
        HashSet<RequestMappingInfo> requestMappingInfos = new HashSet<RequestMappingInfo>();
        for (Method method : methods) {
            if (!this.isHaveRequestMapping(method)) continue;
            try {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)this.getMappingForMethod.invoke((Object)this.requestMappingHandlerMapping, method, aClass);
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo, object, method);
                requestMappingInfos.add(requestMappingInfo);
            }
            catch (Exception e) {
                throw new ProcessorException(e.getMessage());
            }
        }
        return requestMappingInfos;
    }

    private void unregister(ControllerWrapper controllerBeanWrapper) {
        Set<RequestMappingInfo> requestMappingInfos = controllerBeanWrapper.getRequestMappingInfos();
        if (requestMappingInfos != null && !requestMappingInfos.isEmpty()) {
            for (RequestMappingInfo requestMappingInfo : requestMappingInfos) {
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
            }
        }
        if (this.handlerAdapter != null) {
            Class<?> beanClass = controllerBeanWrapper.getBeanClass();
            DestroyUtils.destroyValue(this.handlerAdapter, "sessionAttributesHandlerCache", beanClass);
            DestroyUtils.destroyValue(this.handlerAdapter, "initBinderCache", beanClass);
            DestroyUtils.destroyValue(this.handlerAdapter, "modelAttributeCache", beanClass);
        }
    }

    private boolean isHaveRequestMapping(Method method) {
        return AnnotationUtils.findAnnotation(method, RequestMapping.class) != null;
    }

    static class ControllerWrapper {
        private String beanName;
        private String[] pathPrefix;
        private Class<?> beanClass;
        private Set<RequestMappingInfo> requestMappingInfos;

        ControllerWrapper() {
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public void setBeanClass(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String[] getPathPrefix() {
            return this.pathPrefix;
        }

        public void setPathPrefix(String[] pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public Set<RequestMappingInfo> getRequestMappingInfos() {
            return this.requestMappingInfos;
        }

        public void setRequestMappingInfos(Set<RequestMappingInfo> requestMappingInfos) {
            this.requestMappingInfos = requestMappingInfos;
        }
    }

    private static class ChangeRestPathPostProcessor
    implements BeanPostProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(ChangeRestPathPostProcessor.class);
        private static final String COMMON_ERROR = "\u65e0\u6cd5\u7edf\u4e00\u5904\u7406\u8be5Controller\u8bf7\u6c42\u8def\u5f84\u524d\u7f00";
        private final ProcessorContext processorContext;

        private ChangeRestPathPostProcessor(ProcessorContext processorContext) {
            this.processorContext = processorContext;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            Class<?> aClass = bean.getClass();
            RequestMapping requestMapping = AnnotationUtils.findAnnotation(aClass, RequestMapping.class);
            boolean isController = AnnotationUtils.existOr(aClass, new Class[]{Controller.class, RestController.class});
            if (requestMapping != null && isController) {
                this.changePathForClass(beanName, aClass, requestMapping);
            }
            return bean;
        }

        private void changePathForClass(String beanName, Class<?> aClass, RequestMapping requestMapping) {
            String pluginId = this.processorContext.getPluginDescriptor().getPluginId();
            IntegrationConfiguration configuration = this.processorContext.getConfiguration();
            String pathPrefix = PluginConfigUtils.getPluginRestPrefix((IntegrationConfiguration)configuration, (String)pluginId);
            if (ObjectUtils.isEmpty((CharSequence)pathPrefix)) {
                LOG.error("\u63d2\u4ef6 [{}] Controller\u7c7b [{}] \u672a\u53d1\u73b0 path \u914d\u7f6e, {}", new Object[]{pluginId, aClass.getSimpleName(), COMMON_ERROR});
                return;
            }
            HashSet<String> definePaths = new HashSet<String>();
            definePaths.addAll(Arrays.asList(requestMapping.path()));
            definePaths.addAll(Arrays.asList(requestMapping.value()));
            try {
                Map memberValues = ClassUtils.getAnnotationsUpdater((Object)requestMapping);
                if (memberValues == null) {
                    LOG.error("\u63d2\u4ef6 [{}] Controller \u7c7b [{}] \u65e0\u6cd5\u53cd\u5c04\u83b7\u53d6\u6ce8\u89e3\u5c5e\u6027, {}", new Object[]{pluginId, aClass.getSimpleName(), COMMON_ERROR});
                    return;
                }
                String[] newPath = new String[definePaths.size()];
                int i = 0;
                for (String definePath : definePaths) {
                    if (definePath.contains(pathPrefix)) {
                        newPath[i++] = definePath;
                        continue;
                    }
                    newPath[i++] = UrlUtils.restJoiningPath((String)pathPrefix, (String)definePath);
                }
                if (newPath.length == 0) {
                    newPath = new String[]{pathPrefix};
                }
                memberValues.put("path", newPath);
                memberValues.put("value", newPath);
                ArrayList<ControllerWrapper> controllerWrappers = (ArrayList<ControllerWrapper>)this.processorContext.getRegistryInfo(PluginControllerProcessor.PROCESS_CONTROLLERS);
                if (controllerWrappers == null) {
                    controllerWrappers = new ArrayList<ControllerWrapper>();
                    this.processorContext.addRegistryInfo(PluginControllerProcessor.PROCESS_CONTROLLERS, controllerWrappers);
                }
                ControllerWrapper controllerWrapper = new ControllerWrapper();
                controllerWrapper.setPathPrefix(newPath);
                controllerWrapper.setBeanName(beanName);
                controllerWrapper.setBeanClass(aClass);
                controllerWrappers.add(controllerWrapper);
            }
            catch (Exception e) {
                LOG.error("\u63d2\u4ef6 [{}] Controller \u7c7b[{}] \u6ce8\u518c\u5f02\u5e38. {}", new Object[]{pluginId, aClass.getName(), e.getMessage(), e});
            }
        }
    }
}

