/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.processor.web.thymeleaf;

import com.gitee.starblues.spring.web.thymeleaf.ThymeleafConfig;
import com.gitee.starblues.utils.ObjectUtils;
import org.springframework.core.env.Environment;

public class ThymeleafConfigParse {
    private static final String KEY_PREFIX = "spring.thymeleaf.";
    public static final String ENABLED = "spring.thymeleaf.enabled";
    private static final String PREFIX = "spring.thymeleaf.prefix";
    private static final String SUFFIX = "spring.thymeleaf.suffix";
    private static final String MODE = "spring.thymeleaf.mode";
    private static final String CACHE = "spring.thymeleaf.cache";
    private static final String TEMPLATE_RESOLVER_ORDER = "spring.thymeleaf.templateResolverOrder";

    public static ThymeleafConfig parse(Environment environment) {
        String templateResolverOrder;
        String cache;
        String mode;
        String suffix;
        ThymeleafConfig thymeleafConfig = new ThymeleafConfig();
        String enabled = environment.getProperty(ENABLED);
        if (!ObjectUtils.isEmpty((CharSequence)enabled) && !Boolean.parseBoolean(enabled)) {
            thymeleafConfig.setEnabled(false);
            return thymeleafConfig;
        }
        String prefix = environment.getProperty(PREFIX);
        if (!ObjectUtils.isEmpty((CharSequence)prefix)) {
            thymeleafConfig.setPrefix(prefix);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(suffix = environment.getProperty(SUFFIX)))) {
            thymeleafConfig.setSuffix(suffix);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(mode = environment.getProperty(MODE)))) {
            thymeleafConfig.setMode(mode);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(cache = environment.getProperty(CACHE)))) {
            thymeleafConfig.setCache(Boolean.valueOf(Boolean.getBoolean(cache)));
        }
        if (!ObjectUtils.isEmpty((CharSequence)(templateResolverOrder = environment.getProperty(TEMPLATE_RESOLVER_ORDER)))) {
            thymeleafConfig.setTemplateResolverOrder(Integer.getInteger(templateResolverOrder));
        }
        return thymeleafConfig;
    }
}

