/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.realize;

import com.gitee.starblues.bootstrap.realize.MainEnvironmentProvider;
import com.gitee.starblues.loader.utils.ObjectUtils;
import com.gitee.starblues.spring.MainApplicationContext;
import com.gitee.starblues.utils.MapValueGetter;
import java.util.Collections;
import java.util.Map;

public class DefaultMainEnvironmentProvider
implements MainEnvironmentProvider {
    private final MainApplicationContext mainApplicationContext;

    public DefaultMainEnvironmentProvider(MainApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
    }

    @Override
    public Object getValue(String name) {
        Map configurableEnvironment = this.mainApplicationContext.getConfigurableEnvironment();
        if (ObjectUtils.isEmpty((Object)configurableEnvironment)) {
            return null;
        }
        for (Map.Entry entry : configurableEnvironment.entrySet()) {
            Map value = (Map)entry.getValue();
            Object o = value.get(name);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public String getString(String name) {
        return this.getMapValueGetter(name).getString(name);
    }

    @Override
    public Integer getInteger(String name) {
        return this.getMapValueGetter(name).getInteger(name);
    }

    @Override
    public Long getLong(String name) {
        return this.getMapValueGetter(name).getLong(name);
    }

    @Override
    public Double getDouble(String name) {
        return this.getMapValueGetter(name).getDouble(name);
    }

    @Override
    public Float getFloat(String name) {
        return this.getMapValueGetter(name).getFloat(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.getMapValueGetter(name).getBoolean(name);
    }

    @Override
    public Map<String, Map<String, Object>> getAll() {
        return this.mainApplicationContext.getConfigurableEnvironment();
    }

    private MapValueGetter getMapValueGetter(String name) {
        Map configurableEnvironment = this.mainApplicationContext.getConfigurableEnvironment();
        if (ObjectUtils.isEmpty((Object)configurableEnvironment)) {
            return new MapValueGetter(Collections.emptyMap());
        }
        for (Map.Entry entry : configurableEnvironment.entrySet()) {
            Map value = (Map)entry.getValue();
            if (!value.containsKey(name)) continue;
            return new MapValueGetter(value);
        }
        return new MapValueGetter(Collections.emptyMap());
    }
}

