/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.bootstrap.utils;

import com.gitee.starblues.utils.ReflectionUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class DestroyUtils {
    private DestroyUtils() {
    }

    public static void destroyAll(Object object, String fieldName, Class<?> fieldType) {
        DestroyUtils.destroyAll(object, object.getClass(), fieldName, fieldType);
    }

    public static void destroyAll(Object object, Class<?> objectClass, String fieldName, Class<?> fieldType) {
        try {
            Object fieldObject = ReflectionUtils.getField((Object)object, objectClass, (String)fieldName, fieldType);
            if (fieldObject == null) {
                return;
            }
            DestroyUtils.destroyAll(fieldObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void destroyValue(Object object, String fieldName, Object value) {
        DestroyUtils.destroyValue(object, object.getClass(), fieldName, value);
    }

    public static void destroyValue(Object object, Class<?> objectClass, String fieldName, Object value) {
        DestroyUtils.destroyValue(object, objectClass, fieldName, null, value);
    }

    public static void destroyValue(Object object, Class<?> objectClass, String fieldName, Class<?> fieldType, Object value) {
        try {
            Object fieldObject = ReflectionUtils.getField((Object)object, objectClass, (String)fieldName, fieldType);
            if (fieldObject == null) {
                return;
            }
            DestroyUtils.destroyValue(fieldObject, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void destroyAll(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            ((Map)object).clear();
        } else if (object instanceof Collection) {
            ((Collection)object).clear();
        } else if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            for (int i = 0; i < array.length; ++i) {
                array[i] = null;
            }
        }
    }

    public static void destroyValue(Object object, Object value) {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            ((Map)object).remove(value);
        } else if (object instanceof Collection) {
            ((Collection)object).removeIf(next -> Objects.equals(next, value));
        }
    }
}

