/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.common.cipher;

import com.gitee.starblues.common.cipher.AbstractPluginCipher;
import com.gitee.starblues.utils.Assert;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AesPluginCipher
extends AbstractPluginCipher {
    public static final String SECRET_KEY = "secretKey";
    private static final String INSTANCE_KEY = "AES/ECB/PKCS5Padding";
    private static final String AES_KEY = "AES";

    @Override
    protected String encryptImpl(String sourceStr) throws Exception {
        Key convertSecretKey = this.getKey();
        Cipher cipher = Cipher.getInstance(INSTANCE_KEY);
        cipher.init(1, convertSecretKey);
        byte[] result = cipher.doFinal(sourceStr.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(result);
    }

    @Override
    protected String decryptImpl(String cryptoStr) throws Exception {
        Key convertSecretKey = this.getKey();
        Cipher cipher = Cipher.getInstance(INSTANCE_KEY);
        cipher.init(2, convertSecretKey);
        byte[] decode = Base64.getDecoder().decode(cryptoStr);
        byte[] result = cipher.doFinal(decode);
        return new String(result, StandardCharsets.UTF_8);
    }

    private Key getKey() throws Exception {
        String secretKey = this.parameters.getString(SECRET_KEY);
        Assert.isNotEmpty(secretKey, "secretKey \u4e0d\u80fd\u4e3a\u7a7a");
        byte[] keyBytes = Base64.getDecoder().decode(secretKey);
        return new SecretKeySpec(keyBytes, AES_KEY);
    }

    public static String generateKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(AES_KEY);
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        return Base64.getEncoder().encodeToString(keyBytes);
    }
}

