/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class MapValueGetter {
    private final Map<String, Object> map;

    public MapValueGetter(Map<String, Object> map) {
        this.map = map == null ? Collections.emptyMap() : map;
    }

    public Object getObject(String key) {
        return this.map.get(key);
    }

    public String getString(String key) {
        return this.getValue(key, String::valueOf);
    }

    public Integer getInteger(String key) {
        return this.getValue(key, value -> {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.parseInt(String.valueOf(value));
        });
    }

    public Long getLong(String key) {
        return this.getValue(key, value -> {
            if (value instanceof Long) {
                return (Long)value;
            }
            return Long.parseLong(String.valueOf(value));
        });
    }

    public Double getDouble(String key) {
        return this.getValue(key, value -> {
            if (value instanceof Double) {
                return (Double)value;
            }
            return Double.parseDouble(String.valueOf(value));
        });
    }

    public Float getFloat(String key) {
        return this.getValue(key, value -> {
            if (value instanceof Float) {
                return (Float)value;
            }
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        });
    }

    public Boolean getBoolean(String key) {
        return this.getValue(key, value -> {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(String.valueOf(value));
        });
    }

    private <T> T getValue(String key, Function<Object, T> function) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        return function.apply(value);
    }
}

