/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.ObjectUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;

public class ResourceUtils {
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_CLASSPATH = "classpath";
    public static final String TYPE_PACKAGE = "package";
    public static final String ROOT_PLUGIN_SIGN = "~";
    public static final String TYPE_SPLIT = ":";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String PACKAGE_SPLIT = "/";
    public static final String PACKAGE_SPLIT_DOT = ".";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String ZIP_FILE_EXTENSION = ".zip";
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";

    public static String getMatchLocation(String locationMatch) {
        if (ObjectUtils.isEmpty(locationMatch)) {
            return null;
        }
        String classPathType = CLASSPATH_URL_PREFIX;
        if (ResourceUtils.isClasspath(locationMatch)) {
            return locationMatch.replaceFirst(classPathType, "");
        }
        String fileType = FILE_URL_PREFIX;
        if (ResourceUtils.isFile(locationMatch)) {
            return locationMatch.replaceFirst(fileType, "");
        }
        String packageType = "package:";
        if (ResourceUtils.isPackage(locationMatch)) {
            String location = locationMatch.replaceFirst(packageType, "");
            return ResourceUtils.replacePackage(location);
        }
        return null;
    }

    public static boolean isClasspath(String locationMatch) {
        if (ObjectUtils.isEmpty(locationMatch)) {
            return false;
        }
        return locationMatch.startsWith(CLASSPATH_URL_PREFIX);
    }

    public static boolean isFile(String locationMatch) {
        if (ObjectUtils.isEmpty(locationMatch)) {
            return false;
        }
        return locationMatch.startsWith(FILE_URL_PREFIX);
    }

    public static boolean isPackage(String locationMatch) {
        if (ObjectUtils.isEmpty(locationMatch)) {
            return false;
        }
        return locationMatch.startsWith("package:");
    }

    public static boolean isClass(String path) {
        if (ObjectUtils.isEmpty(path)) {
            return false;
        }
        return path.toLowerCase().endsWith(CLASS_FILE_EXTENSION);
    }

    public static boolean isZipFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && ResourceUtils.isZip(path.toString());
    }

    public static boolean isJarFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && ResourceUtils.isJar(path.toString());
    }

    public static boolean isZip(String name) {
        return name != null && name.toLowerCase().endsWith(ZIP_FILE_EXTENSION);
    }

    public static boolean isJar(String name) {
        return name != null && name.toLowerCase().endsWith(JAR_FILE_EXTENSION);
    }

    public static boolean isDirFile(Path path) {
        return path.toFile().isDirectory();
    }

    public static boolean isJarFileURL(URL url) {
        return "file".equals(url.getProtocol()) || url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return "file".equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean existFile(File rootFile, String checkFileName) {
        if (rootFile == null || !rootFile.exists()) {
            return false;
        }
        File[] listFiles = rootFile.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return false;
        }
        for (File listFile : listFiles) {
            if (Objects.equals(listFile.getName(), checkFileName)) {
                return true;
            }
            if (!listFile.isDirectory()) continue;
            return ResourceUtils.existFile(listFile, checkFileName);
        }
        return false;
    }

    public static void listFile(File rootFile, Consumer<File> consumerFile) {
        if (rootFile == null || !rootFile.exists()) {
            return;
        }
        File[] listFiles = rootFile.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return;
        }
        for (File listFile : listFiles) {
            if (listFile.isDirectory()) {
                ResourceUtils.listFile(listFile, consumerFile);
                continue;
            }
            consumerFile.accept(listFile);
        }
    }

    public static String replacePackage(String packageName) {
        if (packageName == null) {
            return null;
        }
        return packageName.replace(PACKAGE_SPLIT_DOT, PACKAGE_SPLIT);
    }

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static void closeQuietly(Object closeable) {
        ResourceUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Object closeable, Consumer<Exception> consumer) {
        block4: {
            if (closeable != null) {
                try {
                    if (closeable instanceof AutoCloseable) {
                        ((AutoCloseable)closeable).close();
                    }
                }
                catch (Exception e) {
                    if (consumer == null) break block4;
                    consumer.accept(e);
                }
            }
        }
    }

    public static String getFileSuffix(String fileName) {
        if (fileName == null) {
            return null;
        }
        int i = fileName.lastIndexOf(PACKAGE_SPLIT_DOT);
        if (i > 0 && fileName.length() >= i + 1) {
            return fileName.substring(i + 1);
        }
        return "";
    }
}

