/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.ObjectUtils;

public class UrlUtils {
    public static final String SPLIT = "/";

    private UrlUtils() {
    }

    public static String restJoiningPath(String path1, String path2) {
        if (path1 != null && path2 != null) {
            if (path1.endsWith(SPLIT) && path2.startsWith(SPLIT)) {
                return path1 + path2.substring(1);
            }
            if (!path1.endsWith(SPLIT) && !path2.startsWith(SPLIT)) {
                return path1 + SPLIT + path2;
            }
            return path1 + path2;
        }
        if (path1 != null) {
            return path1;
        }
        if (path2 != null) {
            return path2;
        }
        return "";
    }

    public static String joiningUrlPath(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            if (ObjectUtils.isEmpty(path)) continue;
            if (i < length - 1 && path.endsWith(SPLIT)) {
                path = path.substring(path.lastIndexOf(SPLIT));
            }
            if (path.startsWith(SPLIT)) {
                stringBuilder.append(path);
                continue;
            }
            stringBuilder.append(SPLIT).append(path);
        }
        return stringBuilder.toString();
    }

    public static String format(String url) {
        if (ObjectUtils.isEmpty(url)) {
            return url;
        }
        String[] split = url.split(SPLIT);
        StringBuilder stringBuilder = new StringBuilder();
        int length = split.length;
        for (int i = 0; i < length; ++i) {
            String str = split[i];
            if (ObjectUtils.isEmpty(str)) continue;
            if (i < length - 1) {
                stringBuilder.append(str).append(SPLIT);
                continue;
            }
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }
}

