/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader;

import com.gitee.starblues.loader.jar.AbstractJarFile;
import com.gitee.starblues.loader.jar.JarFile;
import com.gitee.starblues.loader.jar.JarFileWrapper;
import com.gitee.starblues.loader.utils.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginResourceStorage {
    public static final Map<String, Storage> STORAGE_MAP = new ConcurrentHashMap<String, Storage>();

    public static void addPlugin(String pluginId, String pluginFileName) {
        if (STORAGE_MAP.containsKey(pluginId)) {
            return;
        }
        STORAGE_MAP.put(pluginId, new Storage(pluginFileName));
    }

    public static void removePlugin(String pluginId) {
        Storage storage = STORAGE_MAP.get(pluginId);
        if (storage == null) {
            return;
        }
        IOUtils.closeQuietly(storage);
        STORAGE_MAP.remove(pluginId);
    }

    public static void addJarFile(AbstractJarFile jarFile) {
        STORAGE_MAP.forEach((k, v) -> v.addJarFile(jarFile.getName(), jarFile));
    }

    public static void addRootJarFile(File file, JarFile jarFile) {
        STORAGE_MAP.forEach((k, v) -> v.addRootJarFile(file, jarFile));
    }

    public static JarFile getRootJarFile(File file) {
        for (Storage value : STORAGE_MAP.values()) {
            JarFile jarFile = value.getRootJarFile(file);
            if (jarFile == null) continue;
            return jarFile;
        }
        return null;
    }

    private static class Storage
    implements Closeable {
        private final String pluginFileName;
        private final Map<File, JarFile> rootJarFileMap = new ConcurrentHashMap<File, JarFile>();
        private final Map<String, List<AbstractJarFile>> jarFileMap = new ConcurrentHashMap<String, List<AbstractJarFile>>();

        public Storage(String pluginFileName) {
            this.pluginFileName = pluginFileName;
        }

        public void addJarFile(String name, AbstractJarFile jarFile) {
            if (name == null || jarFile == null) {
                return;
            }
            if (name.contains(this.pluginFileName)) {
                List jarFiles = this.jarFileMap.computeIfAbsent(name, k -> new ArrayList());
                jarFiles.add(jarFile);
            }
        }

        public void addRootJarFile(File file, JarFile jarFile) {
            String absolutePath = file.getAbsolutePath();
            if (absolutePath.contains(this.pluginFileName)) {
                this.rootJarFileMap.put(file, jarFile);
            }
        }

        public JarFile getRootJarFile(File file) {
            return this.rootJarFileMap.get(file);
        }

        @Override
        public void close() throws IOException {
            for (List<AbstractJarFile> value : this.jarFileMap.values()) {
                for (AbstractJarFile jarFile : value) {
                    if (jarFile == null) continue;
                    if (jarFile instanceof JarFileWrapper) {
                        ((JarFileWrapper)jarFile).canClosed();
                    }
                    IOUtils.closeQuietly(jarFile);
                }
            }
            this.jarFileMap.clear();
            this.rootJarFileMap.clear();
        }
    }
}

