/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.archive;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.jar.Manifest;

public interface Archive
extends Iterable<Entry>,
AutoCloseable {
    public URL getUrl() throws MalformedURLException;

    public Manifest getManifest() throws IOException;

    public Iterator<Archive> getNestedArchives(EntryFilter var1, EntryFilter var2) throws IOException;

    @Override
    public Iterator<Entry> iterator();

    @Override
    default public void forEach(Consumer<? super Entry> action) {
        Objects.requireNonNull(action);
        for (Entry entry : this) {
            action.accept(entry);
        }
    }

    @Override
    default public Spliterator<Entry> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
    }

    default public boolean isExploded() {
        return false;
    }

    @Override
    default public void close() throws Exception {
    }

    @FunctionalInterface
    public static interface EntryFilter {
        public boolean matches(Entry var1);
    }

    public static interface Entry {
        public boolean isDirectory();

        public String getName();
    }
}

