/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader;

import com.gitee.starblues.loader.classloader.resource.Resource;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoader;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoaderFactory;
import com.gitee.starblues.loader.utils.Assert;
import com.gitee.starblues.loader.utils.IOUtils;
import com.gitee.starblues.loader.utils.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GenericClassLoader
extends URLClassLoader {
    private final String name;
    private final ClassLoader parent;
    protected final ResourceLoaderFactory resourceLoaderFactory;
    private final Map<String, Class<?>> pluginClassCache = new ConcurrentHashMap();

    public GenericClassLoader(String name, ResourceLoaderFactory resourceLoaderFactory) {
        this(name, null, resourceLoaderFactory);
    }

    public GenericClassLoader(String name, ClassLoader parent, ResourceLoaderFactory resourceLoaderFactory) {
        super(new URL[0], (ClassLoader)null);
        this.name = Assert.isNotEmpty(name, "name \u4e0d\u80fd\u4e3a\u7a7a");
        this.resourceLoaderFactory = Assert.isNotNull(resourceLoaderFactory, "resourceLoaderFactory \u4e0d\u80fd\u4e3a\u7a7a");
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addResource(String path) throws Exception {
        this.resourceLoaderFactory.addResource(path);
    }

    public void addResource(File file) throws Exception {
        this.resourceLoaderFactory.addResource(file);
    }

    public void addResource(Path path) throws Exception {
        this.resourceLoaderFactory.addResource(path);
    }

    public void addResource(URL url) throws Exception {
        this.resourceLoaderFactory.addResource(url);
    }

    public void addResource(ResourceLoader resourceLoader) throws Exception {
        this.resourceLoaderFactory.addResource(resourceLoader);
    }

    public ClassLoader getParentClassLoader() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            return this.findClass(className);
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> loadedClass = this.findClassFromParent(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        loadedClass = this.findClassFromLocal(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        throw new ClassNotFoundException("ClassLoader[" + this.name + "]:" + className);
    }

    protected Class<?> findClassFromParent(String className) throws ClassNotFoundException {
        try {
            if (this.parent != null) {
                return this.parent.loadClass(className);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class<?> findClassFromLocal(String name) {
        String formatClassName = this.formatClassName(name);
        Class<?> aClass = this.pluginClassCache.get(formatClassName);
        if (aClass != null) {
            return aClass;
        }
        Resource resource = this.resourceLoaderFactory.findResource(formatClassName);
        byte[] bytes = null;
        if (resource != null) {
            bytes = resource.getBytes();
        }
        if (bytes == null || bytes.length == 0) {
            bytes = this.getClassByte(formatClassName);
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        aClass = this.defineClass(name, bytes, 0, bytes.length);
        if (aClass == null) {
            return null;
        }
        if (aClass.getPackage() == null) {
            int lastDotIndex = name.lastIndexOf(46);
            String packageName = lastDotIndex >= 0 ? name.substring(0, lastDotIndex) : "";
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        this.pluginClassCache.put(name, aClass);
        return aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassByte(String formatClassName) {
        InputStream inputStream = this.resourceLoaderFactory.getInputStream(formatClassName);
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.read(inputStream);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    @Override
    public URL[] getURLs() {
        List<URL> urlList = this.resourceLoaderFactory.getUrls();
        URL[] urls = new URL[urlList.size()];
        for (int i = 0; i < urlList.size(); ++i) {
            urls[i] = urlList.get(i);
        }
        return urls;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = this.findInputStreamFromParent(name = this.formatResourceName(name));
        if (inputStream != null) {
            return inputStream;
        }
        return this.findInputStreamFromLocal(name);
    }

    protected InputStream findInputStreamFromParent(String name) {
        if (this.parent != null) {
            return this.parent.getResourceAsStream(name);
        }
        return null;
    }

    protected InputStream findInputStreamFromLocal(String name) {
        return this.resourceLoaderFactory.getInputStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResourceFromParent(name = this.formatResourceName(name));
        if (url != null) {
            return url;
        }
        return this.findResourceFromLocal(name);
    }

    protected URL findResourceFromParent(String name) {
        if (this.parent != null) {
            return this.parent.getResource(name);
        }
        return null;
    }

    protected URL findResourceFromLocal(String name) {
        Resource resource = this.resourceLoaderFactory.findResource(name);
        if (resource == null) {
            return null;
        }
        return resource.getUrl();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        name = this.formatResourceName(name);
        final Enumeration<URL> parentResources = this.findResourcesFromParent(name);
        final Enumeration<URL> localResources = this.findResourcesFromLocal(name);
        return new Enumeration<URL>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                if (parentResources != null && parentResources.hasMoreElements()) {
                    return true;
                }
                this.index = 1;
                return localResources.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.index == 0) {
                    return (URL)parentResources.nextElement();
                }
                return (URL)localResources.nextElement();
            }
        };
    }

    protected Enumeration<URL> findResourcesFromParent(String name) throws IOException {
        if (this.parent != null) {
            return this.parent.getResources(name);
        }
        return null;
    }

    protected Enumeration<URL> findResourcesFromLocal(String name) throws IOException {
        final Enumeration<Resource> enumeration = this.resourceLoaderFactory.findResources(name);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                return ((Resource)enumeration.nextElement()).getUrl();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, Class<?>> map = this.pluginClassCache;
        synchronized (map) {
            this.pluginClassCache.clear();
            IOUtils.closeQuietly(this.resourceLoaderFactory);
        }
    }

    private String formatResourceName(String name) {
        return ResourceUtils.formatStandardName(name);
    }

    private String formatClassName(String className) {
        className = className.replace('/', '~');
        className = className.replace('.', '/') + ".class";
        className = className.replace('~', '/');
        return className;
    }
}

