/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.loader;

import com.gitee.starblues.loader.classloader.filter.ExcludeResource;
import com.gitee.starblues.loader.classloader.filter.IncludeResource;
import com.gitee.starblues.loader.classloader.resource.loader.AbstractResourceLoader;
import com.gitee.starblues.loader.classloader.resource.storage.ResourceStorage;
import java.io.File;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarResourceLoader
extends AbstractResourceLoader {
    private final JarInputStream jarInputStream;
    private ExcludeResource excludeResource = jarEntry -> false;
    private IncludeResource includeResource = jarEntry -> true;

    public JarResourceLoader(File file) throws Exception {
        super(new URL("jar:" + file.toURI().toURL() + "!/"));
        URL url = file.toURI().toURL();
        this.jarInputStream = new JarInputStream(url.openStream());
    }

    public JarResourceLoader(URL url) throws Exception {
        super(url);
        this.jarInputStream = new JarInputStream(url.openStream());
    }

    public JarResourceLoader(URL url, JarInputStream jarInputStream) throws Exception {
        super(url);
        this.jarInputStream = jarInputStream;
    }

    public void setExcludeResource(ExcludeResource excludeResource) {
        if (excludeResource == null) {
            return;
        }
        this.excludeResource = excludeResource;
    }

    public void setIncludeResource(IncludeResource includeResource) {
        if (includeResource == null) {
            return;
        }
        this.includeResource = includeResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadOfChild(ResourceStorage resourceStorage) throws Exception {
        try {
            JarEntry jarEntry = null;
            while ((jarEntry = this.jarInputStream.getNextJarEntry()) != null) {
                if (this.excludeResource.exclude(jarEntry) || !this.includeResource.include(jarEntry)) continue;
                String name = this.resolveName(jarEntry.getName());
                URL url = new URL(this.baseUrl.toString() + name);
                resourceStorage.add(name, url, () -> this.getClassBytes(name, this.jarInputStream, false));
                this.jarInputStream.closeEntry();
            }
        }
        finally {
            this.jarInputStream.close();
        }
    }

    protected String resolveName(String name) {
        return name;
    }
}

