/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.storage;

import com.gitee.starblues.loader.classloader.resource.Resource;
import com.gitee.starblues.loader.classloader.resource.ResourceByteGetter;
import com.gitee.starblues.loader.classloader.resource.loader.DefaultResource;
import com.gitee.starblues.loader.classloader.resource.storage.DefaultResourceStorage;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheResourceStorage
extends DefaultResourceStorage {
    protected final Map<String, Resource> resourceStorage = new ConcurrentHashMap<String, Resource>();

    public CacheResourceStorage(URL baseUrl) {
        super(baseUrl);
    }

    @Override
    public void add(String name, URL url, ResourceByteGetter byteGetter) throws Exception {
        if (this.resourceStorage.containsKey(name = this.formatResourceName(name))) {
            return;
        }
        CacheResource cacheResource = new CacheResource(name, this.baseUrl, url);
        cacheResource.setBytes(byteGetter);
        this.addResource(name, cacheResource);
    }

    private static class CacheResource
    extends DefaultResource {
        private byte[] bytes;

        public CacheResource(String name, URL baseUrl, URL url) {
            super(name, baseUrl, url);
        }

        @Override
        public void setBytes(ResourceByteGetter byteGetter) throws Exception {
            if (byteGetter == null) {
                return;
            }
            this.bytes = byteGetter.get();
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

