/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.storage;

import com.gitee.starblues.loader.classloader.resource.Resource;
import com.gitee.starblues.loader.classloader.resource.ResourceByteGetter;
import com.gitee.starblues.loader.classloader.resource.loader.DefaultResource;
import com.gitee.starblues.loader.classloader.resource.storage.SameRootResourceStorage;
import com.gitee.starblues.loader.utils.Assert;
import com.gitee.starblues.loader.utils.IOUtils;
import com.gitee.starblues.loader.utils.ObjectUtils;
import com.gitee.starblues.loader.utils.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultResourceStorage
extends SameRootResourceStorage {
    protected final Map<String, Resource> resourceStorage = new ConcurrentHashMap<String, Resource>();

    public DefaultResourceStorage(URL baseUrl) {
        super(baseUrl);
    }

    @Override
    public void add(String name, URL url, ResourceByteGetter byteGetter) throws Exception {
        Assert.isNotEmpty(name, "name \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(url, "url \u4e0d\u80fd\u4e3a\u7a7a");
        name = this.formatResourceName(name);
        if (this.resourceStorage.containsKey(name)) {
            return;
        }
        DefaultResource defaultResource = new DefaultResource(name, this.baseUrl, url);
        this.resourceStorage.put(name, defaultResource);
    }

    @Override
    public void add(String name, URL url) throws Exception {
        this.add(name, url, null);
    }

    @Override
    public boolean exist(String name) {
        if (ObjectUtils.isEmpty(name)) {
            return false;
        }
        name = this.formatResourceName(name);
        return this.resourceStorage.containsKey(name);
    }

    protected void addResource(String name, Resource resource) {
        Assert.isNotEmpty(name, "name \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(resource, "resource \u4e0d\u80fd\u4e3a\u7a7a");
        this.resourceStorage.put(name, resource);
    }

    @Override
    public Resource get(String name) {
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        name = this.formatResourceName(name);
        return this.resourceStorage.get(name);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getInputStream(String name) {
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        Resource resourceInfo = this.resourceStorage.get(name = this.formatResourceName(name));
        if (resourceInfo != null) {
            try (InputStream inputStream = resourceInfo.getUrl().openStream();){
                ByteArrayInputStream byteArrayInputStream;
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    IOUtils.copy(inputStream, byteArrayOutputStream);
                    byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                return byteArrayInputStream;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public List<Resource> getAll() {
        return new ArrayList<Resource>(this.resourceStorage.values());
    }

    @Override
    public boolean isEmpty() {
        return this.resourceStorage.isEmpty();
    }

    @Override
    public void close() throws Exception {
        for (Resource resource : this.resourceStorage.values()) {
            IOUtils.closeQuietly(resource);
        }
        this.resourceStorage.clear();
    }

    protected final String formatResourceName(String name) {
        return ResourceUtils.formatStandardName(name);
    }
}

