/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.storage;

import com.gitee.starblues.loader.classloader.resource.ResourceByteGetter;
import com.gitee.starblues.loader.classloader.resource.loader.DefaultResource;
import com.gitee.starblues.loader.classloader.resource.storage.DefaultResourceStorage;
import com.gitee.starblues.loader.utils.Assert;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ShareResourceStorage
extends DefaultResourceStorage {
    private final String key;

    public ShareResourceStorage(String key, URL baseUrl) {
        super(baseUrl);
        this.key = key;
    }

    @Override
    public void add(String name, URL url, ResourceByteGetter byteGetter) throws Exception {
        if (this.resourceStorage.containsKey(name = this.formatResourceName(name))) {
            return;
        }
        ShareResource shareResource = new ShareResource(this.key, name, this.baseUrl, url);
        shareResource.setBytes(byteGetter);
        super.addResource(name, shareResource);
    }

    private static class ByteStore {
        private final String commonByteKey;
        private final Map<String, byte[]> bytesMap = new HashMap<String, byte[]>();

        private ByteStore(String resourceName) {
            this.commonByteKey = resourceName + "_ByteStoreCommon";
        }

        public synchronized void addByte(String key, byte[] bytes) {
            Assert.isNotEmpty(key, "classLoaderName \u4e0d\u80fd\u4e3a\u7a7a");
            if (bytes == null || bytes.length == 0) {
                return;
            }
            byte[] bytesOfMap = this.bytesMap.get(this.commonByteKey);
            if (bytesOfMap != null && bytesOfMap.length > 0) {
                if (Arrays.equals(bytesOfMap, bytes)) {
                    this.bytesMap.put(key, new byte[0]);
                } else {
                    this.bytesMap.put(key, bytes);
                }
                return;
            }
            this.bytesMap.put(this.commonByteKey, bytes);
            this.bytesMap.put(key, new byte[0]);
        }

        public synchronized byte[] getByte(String classLoaderName) {
            byte[] bytes = this.bytesMap.get(classLoaderName);
            if (bytes == null || bytes.length == 0) {
                bytes = this.bytesMap.get(this.commonByteKey);
            }
            return bytes;
        }

        public boolean remove(String classLoaderName) {
            this.bytesMap.remove(classLoaderName);
            if (this.bytesMap.size() == 1 && this.bytesMap.containsKey(this.commonByteKey)) {
                this.bytesMap.clear();
                return true;
            }
            return false;
        }
    }

    private static class ShareResource
    extends DefaultResource {
        private static final Map<String, ByteStore> BYTE_STORE_MAP = new ConcurrentHashMap<String, ByteStore>();
        private final String key;

        public ShareResource(String key, String name, URL baseUrl, URL url) {
            super(name, baseUrl, url);
            this.key = key;
        }

        @Override
        public void setBytes(ResourceByteGetter byteGetter) throws Exception {
            if (byteGetter == null) {
                return;
            }
            byte[] bytes = byteGetter.get();
            String name = this.getName();
            ByteStore byteStore = BYTE_STORE_MAP.get(name);
            if (byteStore == null) {
                byteStore = new ByteStore(name);
                byteStore.addByte(this.key, bytes);
                BYTE_STORE_MAP.put(this.getName(), byteStore);
            } else {
                byteStore.addByte(this.key, bytes);
            }
        }

        @Override
        public byte[] getBytes() {
            String name = this.getName();
            ByteStore byteStore = BYTE_STORE_MAP.get(name);
            if (byteStore == null) {
                return null;
            }
            return byteStore.getByte(this.key);
        }

        @Override
        public void close() throws Exception {
            String name = this.getName();
            ByteStore byteStore = BYTE_STORE_MAP.get(name);
            if (byteStore == null) {
                return;
            }
            if (byteStore.remove(this.key)) {
                BYTE_STORE_MAP.remove(name);
            }
        }
    }
}

