/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.jar;

import com.gitee.starblues.loader.jar.AbstractJarFile;
import com.gitee.starblues.loader.jar.JarFile;
import com.gitee.starblues.loader.utils.IOUtils;
import com.gitee.starblues.loader.utils.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class JarFileWrapper
extends AbstractJarFile {
    private final String parentName;
    private final JarFile parent;
    private final Map<String, List<InputStream>> inputStreamCache;
    private final AtomicBoolean canClosed = new AtomicBoolean(false);

    JarFileWrapper(JarFile parent) throws IOException {
        super(parent.getRootJarFile().getFile());
        this.parent = parent;
        this.parentName = UUID.randomUUID().toString() + parent.getName();
        this.inputStreamCache = new ConcurrentHashMap<String, List<InputStream>>();
    }

    @Override
    URL getUrl() throws MalformedURLException {
        return this.parent.getUrl();
    }

    @Override
    AbstractJarFile.JarFileType getType() {
        return this.parent.getType();
    }

    @Override
    Permission getPermission() {
        return this.parent.getPermission();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.parent.getManifest();
    }

    @Override
    public Enumeration<JarEntry> entries() {
        return this.parent.entries();
    }

    @Override
    public Stream<JarEntry> stream() {
        return this.parent.stream();
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return this.parent.getJarEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.parent.getEntry(name);
    }

    @Override
    InputStream getInputStream() throws IOException {
        InputStream inputStream = this.parent.getInputStream();
        this.addInputStream(this.parentName, inputStream);
        return inputStream;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream inputStream = this.parent.getInputStream(ze);
        this.addInputStream(ze.getName(), inputStream);
        return inputStream;
    }

    @Override
    public String getComment() {
        return this.parent.getComment();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    public String toString() {
        return this.parent.toString();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.canClosed.get()) {
            for (List<InputStream> inputStreams : this.inputStreamCache.values()) {
                if (ObjectUtils.isEmpty(inputStreams)) continue;
                for (InputStream inputStream : inputStreams) {
                    if (inputStream == null) continue;
                    IOUtils.closeQuietly(inputStream);
                }
            }
            this.parent.close();
        }
    }

    public void canClosed() {
        this.canClosed.set(true);
    }

    private void addInputStream(String name, InputStream inputStream) {
        if (inputStream != null) {
            List inputStreams = this.inputStreamCache.computeIfAbsent(name, k -> new ArrayList());
            inputStreams.add(inputStream);
        }
    }

    static JarFile unwrap(java.util.jar.JarFile jarFile) {
        if (jarFile instanceof JarFile) {
            return (JarFile)jarFile;
        }
        if (jarFile instanceof JarFileWrapper) {
            return JarFileWrapper.unwrap(((JarFileWrapper)jarFile).parent);
        }
        throw new IllegalStateException("Not a JarFile or Wrapper");
    }
}

