/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.archive.Archive;
import com.gitee.starblues.loader.archive.ExplodedArchive;
import com.gitee.starblues.loader.archive.JarFileArchive;
import com.gitee.starblues.loader.classloader.GenericClassLoader;
import com.gitee.starblues.loader.classloader.resource.loader.JarResourceLoader;
import com.gitee.starblues.loader.launcher.MainProgramLauncher;
import com.gitee.starblues.loader.launcher.runner.MethodRunner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;

public class MainJarProgramLauncher
extends MainProgramLauncher {
    private static final String PROD_CLASSES_PATH = "classes/";
    private static final String PROD_CLASSES_URL_SIGN = "/classes!/";
    private static final String PROD_LIB_PATH = "lib/";
    private static final Archive.EntryFilter ENTRY_FILTER = entry -> {
        String name = entry.getName();
        return name.startsWith(PROD_CLASSES_PATH) || name.startsWith(PROD_LIB_PATH);
    };
    private static final Archive.EntryFilter INCLUDE_FILTER = entry -> {
        if (entry.isDirectory()) {
            return entry.getName().equals(PROD_CLASSES_PATH);
        }
        return entry.getName().startsWith(PROD_LIB_PATH);
    };
    private final File rootJarFile;

    public MainJarProgramLauncher(MethodRunner methodRunner, File rootJarFile) {
        super(methodRunner);
        this.rootJarFile = Objects.requireNonNull(rootJarFile, "\u53c2\u6570 rootJarFile \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    protected void addResource(GenericClassLoader classLoader) throws Exception {
        super.addResource(classLoader);
        Archive archive = this.getArchive();
        Iterator<Archive> archiveIterator = archive.getNestedArchives(ENTRY_FILTER, INCLUDE_FILTER);
        this.addLibResource(archiveIterator, classLoader);
    }

    private Archive getArchive() throws IOException {
        return this.rootJarFile.isDirectory() ? new ExplodedArchive(this.rootJarFile) : new JarFileArchive(this.rootJarFile);
    }

    private void addLibResource(Iterator<Archive> archives, GenericClassLoader classLoader) throws Exception {
        while (archives.hasNext()) {
            Archive archive = archives.next();
            URL url = archive.getUrl();
            String path = url.getPath();
            if (path.contains(PROD_CLASSES_URL_SIGN)) {
                classLoader.addResource(new MainJarResourceLoader(url));
                continue;
            }
            classLoader.addResource(new JarResourceLoader(url));
        }
    }

    private static class MainJarResourceLoader
    extends JarResourceLoader {
        public MainJarResourceLoader(URL url) throws Exception {
            super(url);
        }

        @Override
        protected String resolveName(String name) {
            return name.replace(MainJarProgramLauncher.PROD_CLASSES_PATH, "");
        }
    }
}

