/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.classloader.GenericClassLoader;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoaderFactory;
import com.gitee.starblues.loader.launcher.AbstractLauncher;
import com.gitee.starblues.loader.launcher.ResourceLoaderFactoryGetter;
import com.gitee.starblues.loader.launcher.runner.MethodRunner;
import com.gitee.starblues.loader.utils.ObjectUtils;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;

public class MainProgramLauncher
extends AbstractLauncher<ClassLoader> {
    public static final String MAIN_CLASS_LOADER_NAME = "MainProgramLauncherClassLoader";
    private final MethodRunner methodRunner;

    public MainProgramLauncher(MethodRunner methodRunner) {
        this.methodRunner = methodRunner;
    }

    @Override
    protected ClassLoader createClassLoader(String ... args) throws Exception {
        GenericClassLoader classLoader = new GenericClassLoader(MAIN_CLASS_LOADER_NAME, this.getParentClassLoader(), this.getResourceLoaderFactory(new String[0]));
        this.addResource(classLoader);
        return classLoader;
    }

    @Override
    protected ClassLoader launch(ClassLoader classLoader, String ... args) throws Exception {
        this.methodRunner.run(classLoader);
        return classLoader;
    }

    protected ResourceLoaderFactory getResourceLoaderFactory(String ... args) {
        return ResourceLoaderFactoryGetter.get(MAIN_CLASS_LOADER_NAME, args);
    }

    protected ClassLoader getParentClassLoader() {
        return MainProgramLauncher.class.getClassLoader();
    }

    protected void addResource(GenericClassLoader classLoader) throws Exception {
        ClassLoader sourceClassLoader;
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        if (!ObjectUtils.isEmpty(classPath)) {
            String[] classPathStr;
            for (String path : classPathStr = classPath.split(";")) {
                classLoader.addResource(path);
            }
        }
        if ((sourceClassLoader = Thread.currentThread().getContextClassLoader()) instanceof URLClassLoader) {
            URL[] urLs;
            URLClassLoader urlClassLoader = (URLClassLoader)sourceClassLoader;
            for (URL url : urLs = urlClassLoader.getURLs()) {
                classLoader.addResource(url);
            }
        }
    }
}

