/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.jar.JarFile;
import com.gitee.starblues.loader.launcher.MainProgramLauncher;
import com.gitee.starblues.loader.launcher.SpringBootstrap;
import com.gitee.starblues.loader.launcher.runner.MainMethodRunner;
import com.gitee.starblues.loader.launcher.runner.MethodRunner;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class SpringMainBootstrap {
    static final String MAIN_RUN_METHOD = "main";
    static final String SPRING_BOOTSTRAP_RUN_METHOD = "run";
    private static final CountDownLatch COUNT_DOWN_LATCH = new CountDownLatch(1);
    private static SpringBootstrap springBootstrap;

    public static void launch(Class<? extends SpringBootstrap> bootstrapClass, String[] args) {
        try {
            SpringBootstrap springBootstrap = bootstrapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            SpringMainBootstrap.launch(springBootstrap, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void launch(SpringBootstrap springBootstrap, String[] args) {
        SpringMainBootstrap.springBootstrap = Objects.requireNonNull(springBootstrap, "springBootBootstrap \u4e0d\u80fd\u4e3a\u7a7a");
        MainMethodRunner mainMethodRunner = new MainMethodRunner(SpringMainBootstrap.class.getName(), MAIN_RUN_METHOD, args);
        JarFile.registerUrlProtocolHandler();
        Thread launchThread = new Thread(new Runner(mainMethodRunner));
        launchThread.start();
        try {
            COUNT_DOWN_LATCH.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void main(String[] args) throws Exception {
        Objects.requireNonNull(springBootstrap, "springBootBootstrap \u4e0d\u80fd\u4e3a\u7a7a");
        MethodRunner run = new MethodRunner(springBootstrap.getClass().getName(), SPRING_BOOTSTRAP_RUN_METHOD, args);
        MainProgramLauncher launcher = new MainProgramLauncher(run);
        launcher.run(args);
    }

    private static class Runner
    implements Runnable {
        private final MethodRunner methodRunner;

        public Runner(MethodRunner methodRunner) {
            this.methodRunner = methodRunner;
        }

        @Override
        public void run() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.methodRunner.run(contextClassLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                COUNT_DOWN_LATCH.countDown();
            }
        }
    }
}

