/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.utils;

import com.gitee.starblues.loader.utils.ObjectUtils;
import java.net.URL;

public class ResourceUtils {
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR_FILE = "jar";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String ZIP_FILE_EXTENSION = ".zip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String PACKAGE_SPLIT = "/";

    private ResourceUtils() {
    }

    public static boolean isJarFileUrl(URL url) {
        String protocol = url.getProtocol();
        boolean extensionIsJar = url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
        return URL_PROTOCOL_FILE.equals(protocol) && extensionIsJar || URL_PROTOCOL_JAR_FILE.equals(protocol) || extensionIsJar;
    }

    public static boolean isZipFileUrl(URL url) {
        String protocol = url.getProtocol();
        boolean extensionIsZip = url.getPath().toLowerCase().endsWith(ZIP_FILE_EXTENSION);
        return URL_PROTOCOL_FILE.equals(protocol) && extensionIsZip;
    }

    public static boolean isJarProtocolUrl(URL url) {
        return URL_PROTOCOL_JAR_FILE.equals(url.getProtocol());
    }

    public static boolean isFileUrl(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static String formatStandardName(String name) {
        if (ObjectUtils.isEmpty(name)) {
            return PACKAGE_SPLIT;
        }
        String[] split = name.split(PACKAGE_SPLIT);
        StringBuilder newPath = null;
        for (String s : split) {
            if ("".equals(s)) continue;
            if (newPath == null) {
                newPath = new StringBuilder(s);
                continue;
            }
            newPath.append(PACKAGE_SPLIT).append(s);
        }
        if (newPath == null || newPath.length() == 0) {
            return PACKAGE_SPLIT;
        }
        return newPath.toString();
    }
}

