/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack;

import com.gitee.starblues.plugin.pack.filter.Exclude;
import com.gitee.starblues.plugin.pack.filter.ExcludeFilter;
import com.gitee.starblues.plugin.pack.filter.Include;
import com.gitee.starblues.plugin.pack.filter.IncludeFilter;
import com.gitee.starblues.plugin.pack.utils.CommonUtils;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;

public abstract class AbstractDependencyFilterMojo
extends AbstractMojo {
    @Parameter(property="spring-brick-packager.includes")
    private List<Include> includes;
    @Parameter(property="spring-brick-packager.excludes")
    private List<Exclude> excludes;

    protected final Set<Artifact> filterDependencies(Set<Artifact> dependencies, FilterArtifacts filters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(filters.filter(dependencies));
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected final FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        if (!ObjectUtils.isEmpty(this.includes)) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (ObjectUtils.isEmpty(this.excludes)) {
            this.excludes = new ArrayList<Exclude>();
        }
        this.addPluginFrameworkExclude();
        this.addSpringWebEnvExclude();
        filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        return filters;
    }

    private void addPluginFrameworkExclude() {
        this.excludes.add(CommonUtils.getPluginFrameworkExclude());
    }

    private void addSpringWebEnvExclude() {
        this.excludes.add(Exclude.get("org.springframework.boot", "spring-boot-starter-web"));
        this.excludes.add(Exclude.get("org.springframework.boot", "spring-boot-starter-tomcat"));
        this.excludes.add(Exclude.get("org.springframework.boot", "spring-boot-starter-json"));
        this.excludes.add(Exclude.get("org.springframework", "spring-webmvc"));
        this.excludes.add(Exclude.get("org.springframework", "spring-web"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDependencyFilterMojo)) {
            return false;
        }
        AbstractDependencyFilterMojo other = (AbstractDependencyFilterMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Include> this$includes = this.getIncludes();
        List<Include> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        List<Exclude> this$excludes = this.getExcludes();
        List<Exclude> other$excludes = other.getExcludes();
        return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDependencyFilterMojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Include> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        List<Exclude> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        return result;
    }

    public List<Include> getIncludes() {
        return this.includes;
    }

    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    public void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    public String toString() {
        return "AbstractDependencyFilterMojo(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }
}

