/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack;

import com.gitee.starblues.plugin.pack.AbstractDependencyFilterMojo;
import com.gitee.starblues.plugin.pack.Constant;
import com.gitee.starblues.plugin.pack.LoadMainResourcePattern;
import com.gitee.starblues.plugin.pack.PluginInfo;
import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public abstract class AbstractPackagerMojo
extends AbstractDependencyFilterMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="spring-brick-packager.mode", defaultValue="dev", required=true)
    private String mode;
    @Parameter(property="spring-brick-packager.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="spring-brick-packager.pluginInfo")
    private PluginInfo pluginInfo;
    @Parameter(property="spring-brick-packager.loadMainResourcePattern", required=false)
    private LoadMainResourcePattern loadMainResourcePattern;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (Constant.isPom(this.getProject().getPackaging())) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping plugin package.");
            return;
        }
        this.pack();
    }

    protected abstract void pack() throws MojoExecutionException, MojoFailureException;

    public final Set<Artifact> getFilterDependencies() throws MojoExecutionException {
        return this.filterDependencies(this.project.getArtifacts(), this.getFilters(new ArtifactsFilter[0]));
    }

    public final Set<Artifact> getSourceDependencies() throws MojoExecutionException {
        return this.project.getArtifacts();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPackagerMojo)) {
            return false;
        }
        AbstractPackagerMojo other = (AbstractPackagerMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSkip() != other.isSkip()) {
            return false;
        }
        MavenProject this$project = this.getProject();
        MavenProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        File this$outputDirectory = this.getOutputDirectory();
        File other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !((Object)this$outputDirectory).equals(other$outputDirectory)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        PluginInfo this$pluginInfo = this.getPluginInfo();
        PluginInfo other$pluginInfo = other.getPluginInfo();
        if (this$pluginInfo == null ? other$pluginInfo != null : !((Object)this$pluginInfo).equals(other$pluginInfo)) {
            return false;
        }
        LoadMainResourcePattern this$loadMainResourcePattern = this.getLoadMainResourcePattern();
        LoadMainResourcePattern other$loadMainResourcePattern = other.getLoadMainResourcePattern();
        return !(this$loadMainResourcePattern == null ? other$loadMainResourcePattern != null : !((Object)this$loadMainResourcePattern).equals(other$loadMainResourcePattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPackagerMojo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSkip() ? 79 : 97);
        MavenProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        File $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : ((Object)$outputDirectory).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        PluginInfo $pluginInfo = this.getPluginInfo();
        result = result * 59 + ($pluginInfo == null ? 43 : ((Object)$pluginInfo).hashCode());
        LoadMainResourcePattern $loadMainResourcePattern = this.getLoadMainResourcePattern();
        result = result * 59 + ($loadMainResourcePattern == null ? 43 : ((Object)$loadMainResourcePattern).hashCode());
        return result;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public LoadMainResourcePattern getLoadMainResourcePattern() {
        return this.loadMainResourcePattern;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPluginInfo(PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public void setLoadMainResourcePattern(LoadMainResourcePattern loadMainResourcePattern) {
        this.loadMainResourcePattern = loadMainResourcePattern;
    }

    @Override
    public String toString() {
        return "AbstractPackagerMojo(project=" + this.getProject() + ", outputDirectory=" + this.getOutputDirectory() + ", mode=" + this.getMode() + ", skip=" + this.isSkip() + ", pluginInfo=" + this.getPluginInfo() + ", loadMainResourcePattern=" + this.getLoadMainResourcePattern() + ")";
    }
}

