/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack;

import com.gitee.starblues.common.AbstractDependencyPlugin;
import com.gitee.starblues.common.PackageStructure;
import com.gitee.starblues.plugin.pack.Constant;
import com.gitee.starblues.plugin.pack.DependencyPlugin;
import com.gitee.starblues.plugin.pack.LoadMainResourcePattern;
import com.gitee.starblues.plugin.pack.PluginInfo;
import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.Repackager;
import com.gitee.starblues.utils.FilesUtils;
import com.gitee.starblues.utils.ObjectUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class BasicRepackager
implements Repackager {
    private String rootDir;
    private String relativeManifestPath;
    private String relativePluginMetaPath;
    private String relativeResourcesDefinePath;
    protected File resourcesDefineFile;
    protected final RepackageMojo repackageMojo;

    public BasicRepackager(RepackageMojo repackageMojo) {
        this.repackageMojo = repackageMojo;
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        this.checkPluginInfo();
        this.rootDir = this.createRootDir();
        this.relativeManifestPath = this.getRelativeManifestPath();
        this.relativePluginMetaPath = this.getRelativePluginMetaPath();
        this.relativeResourcesDefinePath = this.getRelativeResourcesDefinePath();
        try {
            Manifest manifest = this.getManifest();
            this.writeManifest(manifest);
        }
        catch (Exception e) {
            this.repackageMojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException((Throwable)e);
        }
    }

    private void checkPluginInfo() throws MojoExecutionException {
        PluginInfo pluginInfo = this.repackageMojo.getPluginInfo();
        if (pluginInfo == null) {
            throw new MojoExecutionException("configuration.pluginInfo config cannot be empty");
        }
        if (ObjectUtils.isEmpty((CharSequence)pluginInfo.getId())) {
            throw new MojoExecutionException("configuration.pluginInfo.id config cannot be empty");
        }
        String id = pluginInfo.getId();
        String illegal = PackageStructure.getIllegal((String)id);
        if (illegal != null) {
            throw new MojoExecutionException("configuration.pluginInfo.id config can't contain: " + illegal);
        }
        if (ObjectUtils.isEmpty((CharSequence)pluginInfo.getBootstrapClass())) {
            throw new MojoExecutionException("configuration.pluginInfo.bootstrapClass config cannot be empty");
        }
        if (ObjectUtils.isEmpty((CharSequence)pluginInfo.getVersion())) {
            throw new MojoExecutionException("configuration.pluginInfo.version config cannot be empty");
        }
        String version = pluginInfo.getVersion();
        illegal = PackageStructure.getIllegal((String)version);
        if (illegal != null) {
            throw new MojoExecutionException("configuration.pluginInfo.version config can't contain: " + illegal);
        }
    }

    protected String getRelativeManifestPath() {
        return "MANIFEST.MF";
    }

    protected String getRelativeResourcesDefinePath() {
        return "RESOURCES.CONF";
    }

    protected String getRelativePluginMetaPath() {
        return "PLUGIN.META";
    }

    protected String createRootDir() throws MojoFailureException {
        String rootDirPath = this.getBasicRootDir();
        File rootDir = new File(rootDirPath);
        rootDir.deleteOnExit();
        if (rootDir.mkdir()) {
            return rootDirPath;
        }
        throw new MojoFailureException("Failed to create the plugin root directory. " + rootDirPath);
    }

    protected String getBasicRootDir() {
        File outputDirectory = this.repackageMojo.getOutputDirectory();
        return FilesUtils.joiningFilePath((String[])new String[]{outputDirectory.getPath(), "META-INF"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeManifest(Manifest manifest) throws Exception {
        String manifestPath = FilesUtils.joiningFilePath((String[])new String[]{this.rootDir, PackageStructure.resolvePath((String)this.relativeManifestPath)});
        File file = new File(manifestPath);
        FileOutputStream outputStream = null;
        try {
            FileUtils.forceMkdirParent((File)file);
            if (file.createNewFile()) {
                outputStream = new FileOutputStream(file, false);
                manifest.write(outputStream);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.repackageMojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected Manifest getManifest() throws Exception {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Plugin-Meta-Path", this.getPluginMetaInfoPath());
        attributes.putValue("Plugin-Package-Type", "dev");
        return manifest;
    }

    protected String getPluginMetaInfoPath() throws Exception {
        Properties pluginMetaInfo = this.createPluginMetaInfo();
        return this.writePluginMetaInfo(pluginMetaInfo);
    }

    protected Properties createPluginMetaInfo() throws Exception {
        String license;
        String description;
        String dependencyPlugins;
        String requires;
        String provider;
        String args;
        String configFileLocation;
        String configFileName;
        Properties properties = new Properties();
        PluginInfo pluginInfo = this.repackageMojo.getPluginInfo();
        properties.put("plugin.id", pluginInfo.getId());
        properties.put("plugin.bootstrapClass", pluginInfo.getBootstrapClass());
        properties.put("plugin.version", pluginInfo.getVersion());
        properties.put("plugin.system.path", this.getPluginPath());
        String resourcesDefineFilePath = this.writeResourcesDefineFile();
        if (!ObjectUtils.isEmpty((CharSequence)resourcesDefineFilePath)) {
            properties.put("plugin.system.resourcesConfig", resourcesDefineFilePath);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(configFileName = pluginInfo.getConfigFileName()))) {
            properties.put("plugin.configFileName", configFileName);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(configFileLocation = pluginInfo.getConfigFileLocation()))) {
            properties.put("plugin.configFileLocation", configFileLocation);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(args = pluginInfo.getArgs()))) {
            properties.put("plugin.args", args);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(provider = pluginInfo.getProvider()))) {
            properties.put("plugin.provider", provider);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(requires = pluginInfo.getRequires()))) {
            properties.put("plugin.requires", requires);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(dependencyPlugins = this.getDependencyPlugin(pluginInfo)))) {
            properties.put("plugin.dependencies", dependencyPlugins);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(description = pluginInfo.getDescription()))) {
            properties.put("plugin.description", description);
        }
        if (!ObjectUtils.isEmpty((CharSequence)(license = pluginInfo.getLicense()))) {
            properties.put("plugin.license", license);
        }
        return properties;
    }

    protected String getDependencyPlugin(PluginInfo pluginInfo) {
        List<DependencyPlugin> dependencyPlugins = pluginInfo.getDependencyPlugins();
        return AbstractDependencyPlugin.toStr(dependencyPlugins);
    }

    protected String writePluginMetaInfo(Properties properties) throws Exception {
        File pluginMetaFile = this.createPluginMetaFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pluginMetaFile), StandardCharsets.UTF_8);){
            properties.store(writer, "plugin meta configuration");
            String string = pluginMetaFile.getPath();
            return string;
        }
    }

    protected File createPluginMetaFile() throws IOException {
        String path = FilesUtils.joiningFilePath((String[])new String[]{this.rootDir, PackageStructure.resolvePath((String)this.relativePluginMetaPath)});
        return FilesUtils.createFile((String)path);
    }

    protected String getPluginPath() {
        return this.repackageMojo.getProject().getBuild().getOutputDirectory();
    }

    protected String writeResourcesDefineFile() throws Exception {
        this.resourcesDefineFile = this.createResourcesDefineFile();
        this.writeDependenciesIndex();
        this.writeLoadMainResources();
        return this.resourcesDefineFile.getPath();
    }

    protected File createResourcesDefineFile() throws IOException {
        String path = FilesUtils.joiningFilePath((String[])new String[]{this.rootDir, PackageStructure.resolvePath((String)this.relativeResourcesDefinePath)});
        return FilesUtils.createFile((String)path);
    }

    protected void writeDependenciesIndex() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dependencies.index").append("\n");
        Set<String> libIndex = this.getDependenciesIndexSet();
        for (String index : libIndex) {
            stringBuilder.append(index).append("\n");
        }
        String content = stringBuilder.toString();
        FileUtils.write((File)this.resourcesDefineFile, (CharSequence)content, (String)"utf-8", (boolean)true);
    }

    protected Set<String> getDependenciesIndexSet() throws Exception {
        Set<Artifact> dependencies = this.repackageMojo.getFilterDependencies();
        HashSet<String> libPaths = new HashSet<String>(dependencies.size());
        for (Artifact artifact : dependencies) {
            if (this.filterArtifact(artifact)) continue;
            libPaths.add(this.getLibIndex(artifact));
        }
        return libPaths;
    }

    protected String getLibIndex(Artifact artifact) {
        return artifact.getFile().getPath() + this.repackageMojo.resolveLoadToMain(artifact);
    }

    protected void writeLoadMainResources() throws Exception {
        String loadMainResources = this.getLoadMainResources();
        if (ObjectUtils.isEmpty((CharSequence)loadMainResources)) {
            return;
        }
        FileUtils.write((File)this.resourcesDefineFile, (CharSequence)loadMainResources, (String)"utf-8", (boolean)true);
    }

    protected String getLoadMainResources() {
        LoadMainResourcePattern loadMainResourcePattern = this.repackageMojo.getLoadMainResourcePattern();
        if (loadMainResourcePattern == null) {
            return null;
        }
        String[] includes = loadMainResourcePattern.getIncludes();
        String[] excludes = loadMainResourcePattern.getExcludes();
        StringBuilder stringBuilder = new StringBuilder();
        this.addLoadMainResources(stringBuilder, "load.main.resources.includes", includes);
        this.addLoadMainResources(stringBuilder, "load.main.resources.excludes", excludes);
        return stringBuilder.toString();
    }

    private void addLoadMainResources(StringBuilder stringBuilder, String header, String[] patterns) {
        if (ObjectUtils.isEmpty((Object)patterns)) {
            return;
        }
        HashSet<String> patternSet = new HashSet<String>(Arrays.asList(patterns));
        stringBuilder.append(header).append("\n");
        for (String patternStr : patternSet) {
            if (ObjectUtils.isEmpty((CharSequence)patternStr)) continue;
            stringBuilder.append(this.resolvePattern(patternStr)).append("\n");
        }
    }

    protected String resolvePattern(String patternStr) {
        return patternStr.replace(".", "/");
    }

    protected boolean filterArtifact(Artifact artifact) {
        return Constant.scopeFilter(artifact.getScope());
    }

    public String getRootDir() {
        return this.rootDir;
    }
}

