/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack;

import com.gitee.starblues.plugin.pack.AbstractPackagerMojo;
import com.gitee.starblues.plugin.pack.Dependency;
import com.gitee.starblues.plugin.pack.LoadToMain;
import com.gitee.starblues.plugin.pack.PluginInfo;
import com.gitee.starblues.plugin.pack.dev.DevConfig;
import com.gitee.starblues.plugin.pack.dev.DevRepackager;
import com.gitee.starblues.plugin.pack.encrypt.EncryptConfig;
import com.gitee.starblues.plugin.pack.encrypt.EncryptPluginFactory;
import com.gitee.starblues.plugin.pack.main.MainConfig;
import com.gitee.starblues.plugin.pack.main.MainRepackager;
import com.gitee.starblues.plugin.pack.prod.ProdConfig;
import com.gitee.starblues.plugin.pack.prod.ProdRepackager;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractPackagerMojo {
    @Parameter(property="spring-brick-packager.devConfig")
    private DevConfig devConfig;
    @Parameter(property="spring-brick-packager.prodConfig")
    private ProdConfig prodConfig;
    @Parameter(property="spring-brick-packager.mainConfig")
    private MainConfig mainConfig;
    @Parameter(property="spring-brick-packager.mainLoad")
    private LoadToMain loadToMain;
    @Parameter(property="spring-brick-packager.encryptConfig")
    private EncryptConfig encryptConfig;
    private final Set<String> loadToMainSet = new HashSet<String>();

    @Override
    protected void pack() throws MojoExecutionException, MojoFailureException {
        this.initLoadToMainSet();
        String mode = this.getMode();
        try {
            this.encrypt();
        }
        catch (Exception e) {
            throw new MojoExecutionException("encrypt failed: " + e.getMessage());
        }
        if ("prod".equalsIgnoreCase(mode)) {
            new ProdRepackager(this).repackage();
        } else if ("dev".equalsIgnoreCase(mode)) {
            new DevRepackager(this).repackage();
        } else if ("main".equalsIgnoreCase(mode)) {
            new MainRepackager(this).repackage();
        } else {
            throw new MojoExecutionException(mode + " model not supported, mode support : " + "dev" + "/" + "prod");
        }
    }

    public String resolveLoadToMain(Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        if (this.loadToMainSet.contains(artifact.getGroupId() + artifact.getArtifactId())) {
            return "@LOAD_TO_MAIN";
        }
        return "";
    }

    private void initLoadToMainSet() {
        if (this.loadToMain == null) {
            return;
        }
        List<Dependency> dependencies = this.loadToMain.getDependencies();
        if (ObjectUtils.isEmpty(dependencies)) {
            return;
        }
        for (Dependency dependency : dependencies) {
            this.loadToMainSet.add(dependency.getGroupId() + dependency.getArtifactId());
        }
    }

    private void encrypt() throws Exception {
        if (this.encryptConfig == null) {
            return;
        }
        EncryptPluginFactory encryptPlugin = new EncryptPluginFactory();
        PluginInfo pluginInfo = encryptPlugin.encrypt(this.encryptConfig, this.getPluginInfo());
        if (pluginInfo != null) {
            this.setPluginInfo(pluginInfo);
        }
    }

    public DevConfig getDevConfig() {
        return this.devConfig;
    }

    public ProdConfig getProdConfig() {
        return this.prodConfig;
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public LoadToMain getLoadToMain() {
        return this.loadToMain;
    }

    public EncryptConfig getEncryptConfig() {
        return this.encryptConfig;
    }

    public Set<String> getLoadToMainSet() {
        return this.loadToMainSet;
    }
}

